/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.tokenprovider;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.util.ErrorPayloadMappers;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.Operator;
import org.cloudfoundry.reactor.util.OperatorContext;
import org.cloudfoundry.reactor.util.UserAgent;
import org.cloudfoundry.uaa.UaaException;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientRequest;

public abstract class AbstractUaaTokenProvider
implements TokenProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.token");
    private static final String ACCESS_TOKEN = "access_token";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String TOKEN_TYPE = "token_type";
    private static final ZoneId UTC = ZoneId.of("UTC");
    private final ConcurrentMap<ConnectionContext, Mono<String>> accessTokens = new ConcurrentHashMap<ConnectionContext, Mono<String>>(1);
    private final ConcurrentMap<ConnectionContext, RefreshToken> refreshTokenStreams = new ConcurrentHashMap<ConnectionContext, RefreshToken>(1);
    private final ConcurrentMap<ConnectionContext, Mono<String>> refreshTokens = new ConcurrentHashMap<ConnectionContext, Mono<String>>(1);

    @Value.Default
    public String getClientId() {
        return "cf";
    }

    @Value.Default
    public String getClientSecret() {
        return "";
    }

    public Flux<String> getRefreshTokens(ConnectionContext connectionContext) {
        return this.getRefreshTokenStream(connectionContext).processor;
    }

    @Override
    public final Mono<String> getToken(ConnectionContext connectionContext) {
        return this.accessTokens.computeIfAbsent(connectionContext, this::token);
    }

    @Override
    public void invalidate(ConnectionContext connectionContext) {
        this.accessTokens.put(connectionContext, this.token(connectionContext));
    }

    @Nullable
    abstract String getIdentityZoneSubdomain();

    abstract void tokenRequestTransformer(HttpClientRequest var1, HttpClientForm var2);

    private static String extractAccessToken(Map<String, String> payload) {
        String accessToken = payload.get(ACCESS_TOKEN);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access Token: {}", (Object)accessToken);
            AbstractUaaTokenProvider.parseToken(accessToken).ifPresent(claims -> {
                LOGGER.debug("Access Token Issued At:  {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getIssuedAt()));
                LOGGER.debug("Access Token Expires At: {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getExpiration()));
            });
        }
        return String.format("%s %s", payload.get(TOKEN_TYPE), accessToken);
    }

    private static Optional<Claims> parseToken(String token) {
        try {
            String jws = token.substring(0, token.lastIndexOf(46) + 1);
            return Optional.of(Jwts.parser().parseClaimsJwt(jws).getBody());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static void setContentType(HttpHeaders httpHeaders) {
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
    }

    private static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.from(date.toInstant().atZone(UTC));
    }

    private static Function<UriComponentsBuilder, UriComponentsBuilder> tokenUriTransformer(String identityZoneId) {
        return root -> {
            if (identityZoneId != null) {
                root.host(String.format("%s.%s", identityZoneId, root.build().getHost()));
            }
            return root.pathSegment(new String[]{"oauth", "token"});
        };
    }

    private void addHeaders(HttpHeaders httpHeaders) {
        AbstractUaaTokenProvider.setContentType(httpHeaders);
        this.setAuthorization(httpHeaders);
        UserAgent.setUserAgent(httpHeaders);
        JsonCodec.setDecodeHeaders(httpHeaders);
    }

    private Operator createOperator(ConnectionContext connectionContext, String root) {
        OperatorContext context = OperatorContext.of(connectionContext, root);
        return new Operator(context, connectionContext.getHttpClient()).withErrorPayloadMapper(ErrorPayloadMappers.uaa(connectionContext.getObjectMapper()));
    }

    private Consumer<Map<String, String>> extractRefreshToken(ConnectionContext connectionContext) {
        return payload -> Optional.ofNullable(payload.get(REFRESH_TOKEN)).ifPresent(refreshToken -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Refresh Token: {}", refreshToken);
                AbstractUaaTokenProvider.parseToken(refreshToken).ifPresent(claims -> {
                    LOGGER.debug("Refresh Token Issued At:  {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getIssuedAt()));
                    LOGGER.debug("Refresh Token Expires At: {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getExpiration()));
                });
            }
            this.refreshTokens.put(connectionContext, (Mono<String>)Mono.just((Object)refreshToken));
            this.getRefreshTokenStream(connectionContext).sink.next(refreshToken);
        });
    }

    private RefreshToken getRefreshTokenStream(ConnectionContext connectionContext) {
        return this.refreshTokenStreams.computeIfAbsent(connectionContext, c -> new RefreshToken());
    }

    private Mono<String> primaryToken(ConnectionContext connectionContext) {
        return this.requestToken(connectionContext, this::tokenRequestTransformer, this.tokensExtractor(connectionContext));
    }

    private Mono<String> refreshToken(ConnectionContext connectionContext, String refreshToken) {
        return this.requestToken(connectionContext, this.refreshTokenGrantTokenRequestTransformer(refreshToken), this.tokensExtractor(connectionContext)).onErrorResume(t -> t instanceof UaaException && ((UaaException)t).getStatusCode() == HttpResponseStatus.UNAUTHORIZED.code(), t -> Mono.empty());
    }

    private BiConsumer<HttpClientRequest, HttpClientForm> refreshTokenGrantTokenRequestTransformer(String refreshToken) {
        return (request, form) -> form.multipart(false).attr("client_id", this.getClientId()).attr("client_secret", this.getClientSecret()).attr("grant_type", REFRESH_TOKEN).attr(REFRESH_TOKEN, refreshToken);
    }

    private Mono<String> requestToken(ConnectionContext connectionContext, BiConsumer<HttpClientRequest, HttpClientForm> tokenRequestTransformer, Function<ByteBufFlux, Mono<String>> tokenExtractor) {
        return connectionContext.getRootProvider().getRoot(AUTHORIZATION_ENDPOINT, connectionContext).map(root -> this.createOperator(connectionContext, (String)root)).flatMap(operator -> operator.headers(this::addHeaders).post().uri(AbstractUaaTokenProvider.tokenUriTransformer(this.getIdentityZoneSubdomain())).sendForm(tokenRequestTransformer).response().parseBodyToMono(responseWithBody -> (Mono)tokenExtractor.apply(responseWithBody.getBody())));
    }

    private void setAuthorization(HttpHeaders headers) {
        String encoded = Base64.getEncoder().encodeToString(new AsciiString((CharSequence)this.getClientId()).concat((CharSequence)":").concat((CharSequence)this.getClientSecret()).toByteArray());
        headers.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)String.format("Basic %s", encoded));
    }

    private Mono<String> token(ConnectionContext connectionContext) {
        Mono cached = this.refreshTokens.getOrDefault(connectionContext, (Mono<String>)Mono.empty()).flatMap(refreshToken -> this.refreshToken(connectionContext, (String)refreshToken).doOnSubscribe(s -> LOGGER.debug("Negotiating using refresh token"))).switchIfEmpty(this.primaryToken(connectionContext).doOnSubscribe(s -> LOGGER.debug("Negotiating using token provider")));
        return connectionContext.getCacheDuration().map(arg_0 -> ((Mono)cached).cache(arg_0)).orElseGet(() -> ((Mono)cached).cache()).checkpoint();
    }

    private Function<ByteBufFlux, Mono<String>> tokensExtractor(ConnectionContext connectionContext) {
        return body -> JsonCodec.decode(connectionContext.getObjectMapper(), body, Map.class).map(payload -> payload).doOnNext(this.extractRefreshToken(connectionContext)).map(AbstractUaaTokenProvider::extractAccessToken);
    }

    private static final class RefreshToken {
        private ReplayProcessor<String> processor = ReplayProcessor.cacheLast();
        private FluxSink<String> sink = this.processor.sink();

        private RefreshToken() {
        }
    }
}

