/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.Exceptions;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientRequest;

public final class MultipartHttpClientRequest {
    private final HttpClientForm form;
    private final ObjectMapper objectMapper;
    private final List<Consumer<PartHttpClientRequest>> partConsumers = new ArrayList<Consumer<PartHttpClientRequest>>();
    private final HttpClientRequest request;

    public MultipartHttpClientRequest(ObjectMapper objectMapper, HttpClientRequest request, HttpClientForm form) {
        this.objectMapper = objectMapper;
        this.request = request;
        this.form = form;
    }

    public MultipartHttpClientRequest addPart(Consumer<PartHttpClientRequest> partConsumer) {
        this.partConsumers.add(partConsumer);
        return this;
    }

    public void done() {
        List parts = this.partConsumers.stream().map(partConsumer -> {
            PartHttpClientRequest part = new PartHttpClientRequest(this.objectMapper);
            partConsumer.accept(part);
            return part;
        }).collect(Collectors.toList());
        this.request.requestHeaders().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        this.form.multipart(true);
        HttpClientForm intermediateForm = this.form;
        for (PartHttpClientRequest part : parts) {
            intermediateForm = part.send(intermediateForm);
        }
    }

    public static final class PartHttpClientRequest {
        private final ObjectMapper objectMapper;
        private String contentType;
        private Path file;
        private String filename;
        private String name;
        private ByteArrayInputStream payload;

        private PartHttpClientRequest(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public void send(Object source) {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes(source);
                this.payload = new ByteArrayInputStream(bytes);
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public void sendFile(Path file) {
            this.file = file;
        }

        public PartHttpClientRequest setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public PartHttpClientRequest setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public PartHttpClientRequest setName(String name) {
            this.name = name;
            return this;
        }

        private String getFilenameOrDefault() {
            return this.filename != null ? this.filename : this.file.getFileName().toString();
        }

        private HttpClientForm send(HttpClientForm form) {
            if (this.file != null) {
                return form.file(this.name, this.getFilenameOrDefault(), this.file.toFile(), this.contentType);
            }
            if (this.payload != null) {
                return form.file(this.name, (InputStream)this.payload, this.contentType);
            }
            return form;
        }
    }
}

