package org.cloudfoundry.reactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * A {@link RootProvider} that returns a single endpoint regardless of what key is requested.  Often used with standalone Cloud Foundry components such as the UAA.
 */
@Generated(from = "_SingleEndpointRootProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SingleEndpointRootProvider extends org.cloudfoundry.reactor._SingleEndpointRootProvider {
  private final String apiHost;
  private final Integer port;
  private final Boolean secure;

  private SingleEndpointRootProvider(SingleEndpointRootProvider.Builder builder) {
    this.apiHost = builder.apiHost;
    this.port = builder.port;
    this.secure = builder.secure;
  }

  /**
   * The hostname of the API root. Typically something like {@code api.run.pivotal.io}.
   */
  @Override
  public String getApiHost() {
    return apiHost;
  }

  /**
   * The port for the Cloud Foundry instance. Defaults to {@code 443}.
   */
  @Override
  public Optional<Integer> getPort() {
    return Optional.ofNullable(port);
  }

  /**
   * Whether the connection to the root API should be secure (i.e. using HTTPS). Defaults to {@code true}.
   */
  @Override
  public Optional<Boolean> getSecure() {
    return Optional.ofNullable(secure);
  }

  /**
   * This instance is equal to all instances of {@code SingleEndpointRootProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SingleEndpointRootProvider
        && equalTo((SingleEndpointRootProvider) another);
  }

  private boolean equalTo(SingleEndpointRootProvider another) {
    return apiHost.equals(another.apiHost)
        && Objects.equals(port, another.port)
        && Objects.equals(secure, another.secure);
  }

  /**
   * Computes a hash code from attributes: {@code apiHost}, {@code port}, {@code secure}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + apiHost.hashCode();
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(secure);
    return h;
  }

  /**
   * Prints the immutable value {@code SingleEndpointRootProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SingleEndpointRootProvider{");
    builder.append("apiHost=").append(apiHost);
    if (port != null) {
      builder.append(", ");
      builder.append("port=").append(port);
    }
    if (secure != null) {
      builder.append(", ");
      builder.append("secure=").append(secure);
    }
    return builder.append("}").toString();
  }

  private static SingleEndpointRootProvider validate(SingleEndpointRootProvider instance) {
    instance.checkForValidApiHost();
    return instance;
  }

  /**
   * Creates a builder for {@link SingleEndpointRootProvider SingleEndpointRootProvider}.
   * <pre>
   * SingleEndpointRootProvider.builder()
   *    .apiHost(String) // required {@link SingleEndpointRootProvider#getApiHost() apiHost}
   *    .port(Integer) // optional {@link SingleEndpointRootProvider#getPort() port}
   *    .secure(Boolean) // optional {@link SingleEndpointRootProvider#getSecure() secure}
   *    .build();
   * </pre>
   * @return A new SingleEndpointRootProvider builder
   */
  public static SingleEndpointRootProvider.Builder builder() {
    return new SingleEndpointRootProvider.Builder();
  }

  /**
   * Builds instances of type {@link SingleEndpointRootProvider SingleEndpointRootProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SingleEndpointRootProvider", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_API_HOST = 0x1L;
    private long initBits = 0x1L;

    private String apiHost;
    private Integer port;
    private Boolean secure;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.AbstractRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code SingleEndpointRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SingleEndpointRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _SingleEndpointRootProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_SingleEndpointRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractRootProvider) {
        AbstractRootProvider instance = (AbstractRootProvider) object;
        Optional<Boolean> secureOptional = instance.getSecure();
        if (secureOptional.isPresent()) {
          secure(secureOptional);
        }
        Optional<Integer> portOptional = instance.getPort();
        if (portOptional.isPresent()) {
          port(portOptional);
        }
        apiHost(instance.getApiHost());
      }
    }

    /**
     * Initializes the value for the {@link SingleEndpointRootProvider#getApiHost() apiHost} attribute.
     * @param apiHost The value for apiHost 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apiHost(String apiHost) {
      this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
      initBits &= ~INIT_BIT_API_HOST;
      return this;
    }

    /**
     * Initializes the optional value {@link SingleEndpointRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the optional value {@link SingleEndpointRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = port.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SingleEndpointRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for chained invocation
     */
    public final Builder secure(boolean secure) {
      this.secure = secure;
      return this;
    }

    /**
     * Initializes the optional value {@link SingleEndpointRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secure(Optional<Boolean> secure) {
      this.secure = secure.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SingleEndpointRootProvider SingleEndpointRootProvider}.
     * @return An immutable instance of SingleEndpointRootProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SingleEndpointRootProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return SingleEndpointRootProvider.validate(new SingleEndpointRootProvider(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_API_HOST) != 0) attributes.add("apiHost");
      return "Cannot build SingleEndpointRootProvider, some of required attributes are not set " + attributes;
    }
  }
}
