/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.services;

import java.util.Map;
import org.cloudfoundry.client.v2.services.DeleteServiceRequest;
import org.cloudfoundry.client.v2.services.DeleteServiceResponse;
import org.cloudfoundry.client.v2.services.GetServiceRequest;
import org.cloudfoundry.client.v2.services.GetServiceResponse;
import org.cloudfoundry.client.v2.services.ListServiceServicePlansRequest;
import org.cloudfoundry.client.v2.services.ListServiceServicePlansResponse;
import org.cloudfoundry.client.v2.services.ListServicesRequest;
import org.cloudfoundry.client.v2.services.ListServicesResponse;
import org.cloudfoundry.client.v2.services.Services;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorServices
extends AbstractClientV2Operations
implements Services {
    public ReactorServices(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<DeleteServiceResponse> delete(DeleteServiceRequest request) {
        return this.delete(request, DeleteServiceResponse.class, builder -> builder.pathSegment(new String[]{"services", request.getServiceId()})).checkpoint();
    }

    public Mono<GetServiceResponse> get(GetServiceRequest request) {
        return this.get((Object)request, GetServiceResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"services", request.getServiceId()})).checkpoint();
    }

    public Mono<ListServicesResponse> list(ListServicesRequest request) {
        return this.get((Object)request, ListServicesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"services"})).checkpoint();
    }

    public Mono<ListServiceServicePlansResponse> listServicePlans(ListServiceServicePlansRequest request) {
        return this.get((Object)request, ListServiceServicePlansResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"services", request.getServiceId(), "service_plans"})).checkpoint();
    }
}

