/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.UsernameProvider;
import org.cloudfoundry.reactor.uaa._ReactorUaaClient;
import org.cloudfoundry.uaa.authorizations.Authorizations;
import org.cloudfoundry.uaa.clients.Clients;
import org.cloudfoundry.uaa.groups.Groups;
import org.cloudfoundry.uaa.identityproviders.IdentityProviders;
import org.cloudfoundry.uaa.identityzones.IdentityZones;
import org.cloudfoundry.uaa.serverinformation.ServerInformation;
import org.cloudfoundry.uaa.tokens.Tokens;
import org.cloudfoundry.uaa.users.Users;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

@Generated(from="_ReactorUaaClient", generator="Immutables")
public final class ReactorUaaClient
extends _ReactorUaaClient {
    private final transient Authorizations authorizations;
    private final transient Clients clients;
    private final transient Mono<String> username;
    private final transient Groups groups;
    private final transient IdentityProviders identityProviders;
    private final transient IdentityZones identityZones;
    private final transient ServerInformation serverInformation;
    private final transient Tokens tokens;
    private final transient Users users;
    private final ConnectionContext connectionContext;
    @Nullable
    private final String identityZoneSubdomain;
    private final Map<String, String> requestTags;
    private final Mono<String> root;
    private final TokenProvider tokenProvider;
    private final UsernameProvider usernameProvider;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ReactorUaaClient(Builder builder) {
        this.connectionContext = builder.connectionContext;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
        this.tokenProvider = builder.tokenProvider;
        if (builder.requestTagsIsSet()) {
            this.initShim.requestTags(ReactorUaaClient.createUnmodifiableMap(false, false, builder.requestTags));
        }
        if (builder.root != null) {
            this.initShim.root((Mono<String>)builder.root);
        }
        if (builder.usernameProvider != null) {
            this.initShim.usernameProvider(builder.usernameProvider);
        }
        this.authorizations = this.initShim.authorizations();
        this.clients = this.initShim.clients();
        this.username = this.initShim.getUsername();
        this.groups = this.initShim.groups();
        this.identityProviders = this.initShim.identityProviders();
        this.identityZones = this.initShim.identityZones();
        this.serverInformation = this.initShim.serverInformation();
        this.tokens = this.initShim.tokens();
        this.users = this.initShim.users();
        this.requestTags = this.initShim.getRequestTags();
        this.root = this.initShim.getRoot();
        this.usernameProvider = this.initShim.getUsernameProvider();
        this.initShim = null;
    }

    @Override
    public Authorizations authorizations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.authorizations() : this.authorizations;
    }

    @Override
    public Clients clients() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clients() : this.clients;
    }

    @Override
    public Mono<String> getUsername() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUsername() : this.username;
    }

    @Override
    public Groups groups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.groups() : this.groups;
    }

    @Override
    public IdentityProviders identityProviders() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identityProviders() : this.identityProviders;
    }

    @Override
    public IdentityZones identityZones() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identityZones() : this.identityZones;
    }

    @Override
    public ServerInformation serverInformation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.serverInformation() : this.serverInformation;
    }

    @Override
    public Tokens tokens() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tokens() : this.tokens;
    }

    @Override
    public Users users() {
        InitShim shim = this.initShim;
        return shim != null ? shim.users() : this.users;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    @Override
    public Map<String, String> getRequestTags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRequestTags() : this.requestTags;
    }

    @Override
    public Mono<String> getRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoot() : this.root;
    }

    @Override
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @Override
    public UsernameProvider getUsernameProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUsernameProvider() : this.usernameProvider;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReactorUaaClient && this.equalTo((ReactorUaaClient)another);
    }

    private boolean equalTo(ReactorUaaClient another) {
        return this.authorizations.equals(another.authorizations) && this.clients.equals(another.clients) && this.username.equals(another.username) && this.groups.equals(another.groups) && this.identityProviders.equals(another.identityProviders) && this.identityZones.equals(another.identityZones) && this.serverInformation.equals(another.serverInformation) && this.tokens.equals(another.tokens) && this.users.equals(another.users) && this.connectionContext.equals(another.connectionContext) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain) && this.requestTags.equals(another.requestTags) && this.root.equals(another.root) && this.tokenProvider.equals(another.tokenProvider) && this.usernameProvider.equals(another.usernameProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authorizations.hashCode();
        h += (h << 5) + this.clients.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.identityProviders.hashCode();
        h += (h << 5) + this.identityZones.hashCode();
        h += (h << 5) + this.serverInformation.hashCode();
        h += (h << 5) + this.tokens.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + this.connectionContext.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        h += (h << 5) + this.requestTags.hashCode();
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.tokenProvider.hashCode();
        h += (h << 5) + this.usernameProvider.hashCode();
        return h;
    }

    public String toString() {
        return "ReactorUaaClient{authorizations=" + this.authorizations + ", clients=" + this.clients + ", username=" + this.username + ", groups=" + this.groups + ", identityProviders=" + this.identityProviders + ", identityZones=" + this.identityZones + ", serverInformation=" + this.serverInformation + ", tokens=" + this.tokens + ", users=" + this.users + ", connectionContext=" + this.connectionContext + ", identityZoneSubdomain=" + this.identityZoneSubdomain + ", requestTags=" + this.requestTags + ", root=" + this.root + ", tokenProvider=" + this.tokenProvider + ", usernameProvider=" + this.usernameProvider + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ReactorUaaClient", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_CONTEXT = 1L;
        private static final long INIT_BIT_TOKEN_PROVIDER = 2L;
        private static final long OPT_BIT_REQUEST_TAGS = 1L;
        private long initBits = 3L;
        private long optBits;
        private ConnectionContext connectionContext;
        private String identityZoneSubdomain;
        private Map<String, String> requestTags = new LinkedHashMap<String, String>();
        private Mono<String> root;
        private TokenProvider tokenProvider;
        private UsernameProvider usernameProvider;

        private Builder() {
        }

        public final Builder from(ReactorUaaClient instance) {
            return this.from((_ReactorUaaClient)instance);
        }

        final Builder from(_ReactorUaaClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionContext(instance.getConnectionContext());
            String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
            if (identityZoneSubdomainValue != null) {
                this.identityZoneSubdomain(identityZoneSubdomainValue);
            }
            this.putAllRequestTags(instance.getRequestTags());
            this.root(instance.getRoot());
            this.tokenProvider(instance.getTokenProvider());
            this.usernameProvider(instance.getUsernameProvider());
            return this;
        }

        public final Builder connectionContext(ConnectionContext connectionContext) {
            this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public final Builder requestTag(String key, String value) {
            this.requestTags.put(Objects.requireNonNull(key, "requestTags key"), Objects.requireNonNull(value, "requestTags value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTag(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, "requestTags value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTags(Map<String, ? extends String> entries) {
            this.requestTags.clear();
            this.optBits |= 1L;
            return this.putAllRequestTags(entries);
        }

        public final Builder putAllRequestTags(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, "requestTags value"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder root(Mono<String> root) {
            this.root = Objects.requireNonNull(root, "root");
            return this;
        }

        public final Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder usernameProvider(UsernameProvider usernameProvider) {
            this.usernameProvider = Objects.requireNonNull(usernameProvider, "usernameProvider");
            return this;
        }

        public ReactorUaaClient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReactorUaaClient(this);
        }

        private boolean requestTagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenProvider");
            }
            return "Cannot build ReactorUaaClient, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_ReactorUaaClient", generator="Immutables")
    private final class InitShim {
        private byte authorizationsBuildStage = 0;
        private Authorizations authorizations;
        private byte clientsBuildStage = 0;
        private Clients clients;
        private byte usernameBuildStage = 0;
        private Mono<String> username;
        private byte groupsBuildStage = 0;
        private Groups groups;
        private byte identityProvidersBuildStage = 0;
        private IdentityProviders identityProviders;
        private byte identityZonesBuildStage = 0;
        private IdentityZones identityZones;
        private byte serverInformationBuildStage = 0;
        private ServerInformation serverInformation;
        private byte tokensBuildStage = 0;
        private Tokens tokens;
        private byte usersBuildStage = 0;
        private Users users;
        private byte requestTagsBuildStage = 0;
        private Map<String, String> requestTags;
        private byte rootBuildStage = 0;
        private Mono<String> root;
        private byte usernameProviderBuildStage = 0;
        private UsernameProvider usernameProvider;

        private InitShim() {
        }

        Authorizations authorizations() {
            if (this.authorizationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorizationsBuildStage == 0) {
                this.authorizationsBuildStage = (byte)-1;
                this.authorizations = Objects.requireNonNull(ReactorUaaClient.super.authorizations(), "authorizations");
                this.authorizationsBuildStage = 1;
            }
            return this.authorizations;
        }

        Clients clients() {
            if (this.clientsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientsBuildStage == 0) {
                this.clientsBuildStage = (byte)-1;
                this.clients = Objects.requireNonNull(ReactorUaaClient.super.clients(), "clients");
                this.clientsBuildStage = 1;
            }
            return this.clients;
        }

        Mono<String> getUsername() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ReactorUaaClient.super.getUsername(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        Groups groups() {
            if (this.groupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupsBuildStage == 0) {
                this.groupsBuildStage = (byte)-1;
                this.groups = Objects.requireNonNull(ReactorUaaClient.super.groups(), "groups");
                this.groupsBuildStage = 1;
            }
            return this.groups;
        }

        IdentityProviders identityProviders() {
            if (this.identityProvidersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identityProvidersBuildStage == 0) {
                this.identityProvidersBuildStage = (byte)-1;
                this.identityProviders = Objects.requireNonNull(ReactorUaaClient.super.identityProviders(), "identityProviders");
                this.identityProvidersBuildStage = 1;
            }
            return this.identityProviders;
        }

        IdentityZones identityZones() {
            if (this.identityZonesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identityZonesBuildStage == 0) {
                this.identityZonesBuildStage = (byte)-1;
                this.identityZones = Objects.requireNonNull(ReactorUaaClient.super.identityZones(), "identityZones");
                this.identityZonesBuildStage = 1;
            }
            return this.identityZones;
        }

        ServerInformation serverInformation() {
            if (this.serverInformationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.serverInformationBuildStage == 0) {
                this.serverInformationBuildStage = (byte)-1;
                this.serverInformation = Objects.requireNonNull(ReactorUaaClient.super.serverInformation(), "serverInformation");
                this.serverInformationBuildStage = 1;
            }
            return this.serverInformation;
        }

        Tokens tokens() {
            if (this.tokensBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tokensBuildStage == 0) {
                this.tokensBuildStage = (byte)-1;
                this.tokens = Objects.requireNonNull(ReactorUaaClient.super.tokens(), "tokens");
                this.tokensBuildStage = 1;
            }
            return this.tokens;
        }

        Users users() {
            if (this.usersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usersBuildStage == 0) {
                this.usersBuildStage = (byte)-1;
                this.users = Objects.requireNonNull(ReactorUaaClient.super.users(), "users");
                this.usersBuildStage = 1;
            }
            return this.users;
        }

        Map<String, String> getRequestTags() {
            if (this.requestTagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestTagsBuildStage == 0) {
                this.requestTagsBuildStage = (byte)-1;
                this.requestTags = ReactorUaaClient.createUnmodifiableMap(true, false, ReactorUaaClient.super.getRequestTags());
                this.requestTagsBuildStage = 1;
            }
            return this.requestTags;
        }

        void requestTags(Map<String, String> requestTags) {
            this.requestTags = requestTags;
            this.requestTagsBuildStage = 1;
        }

        Mono<String> getRoot() {
            if (this.rootBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootBuildStage == 0) {
                this.rootBuildStage = (byte)-1;
                this.root = Objects.requireNonNull(ReactorUaaClient.super.getRoot(), "root");
                this.rootBuildStage = 1;
            }
            return this.root;
        }

        void root(Mono<String> root) {
            this.root = root;
            this.rootBuildStage = 1;
        }

        UsernameProvider getUsernameProvider() {
            if (this.usernameProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameProviderBuildStage == 0) {
                this.usernameProviderBuildStage = (byte)-1;
                this.usernameProvider = Objects.requireNonNull(ReactorUaaClient.super.getUsernameProvider(), "usernameProvider");
                this.usernameProviderBuildStage = 1;
            }
            return this.usernameProvider;
        }

        void usernameProvider(UsernameProvider usernameProvider) {
            this.usernameProvider = usernameProvider;
            this.usernameProviderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.authorizationsBuildStage == -1) {
                attributes.add("authorizations");
            }
            if (this.clientsBuildStage == -1) {
                attributes.add("clients");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.groupsBuildStage == -1) {
                attributes.add("groups");
            }
            if (this.identityProvidersBuildStage == -1) {
                attributes.add("identityProviders");
            }
            if (this.identityZonesBuildStage == -1) {
                attributes.add("identityZones");
            }
            if (this.serverInformationBuildStage == -1) {
                attributes.add("serverInformation");
            }
            if (this.tokensBuildStage == -1) {
                attributes.add("tokens");
            }
            if (this.usersBuildStage == -1) {
                attributes.add("users");
            }
            if (this.requestTagsBuildStage == -1) {
                attributes.add("requestTags");
            }
            if (this.rootBuildStage == -1) {
                attributes.add("root");
            }
            if (this.usernameProviderBuildStage == -1) {
                attributes.add("usernameProvider");
            }
            return "Cannot build ReactorUaaClient, attribute initializers form cycle " + attributes;
        }
    }
}

