/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.cloudfoundry.reactor.util.UriQueryParameter;
import org.cloudfoundry.reactor.util.UriQueryParameterBuilder;

public final class QueryBuilder
implements UriQueryParameterBuilder {
    @Override
    public Stream<UriQueryParameter> build(Object instance) {
        return AnnotationUtils.streamAnnotatedValues(instance, QueryParameter.class).map(QueryBuilder::processValue).filter(Objects::nonNull);
    }

    private static UriQueryParameter processCollection(QueryParameter queryParameter, Object value) {
        return QueryBuilder.processValue(queryParameter.value(), ((Collection)value).stream().map(Object::toString).map(String::trim).collect(Collectors.joining(queryParameter.delimiter())));
    }

    private static UriQueryParameter processValue(AnnotationUtils.AnnotatedValue<QueryParameter> annotatedValue) {
        QueryParameter queryParameter = annotatedValue.getAnnotation();
        Object value = annotatedValue.getValue();
        if (value instanceof Collection) {
            return QueryBuilder.processCollection(queryParameter, value);
        }
        return QueryBuilder.processValue(queryParameter.value(), value.toString());
    }

    private static UriQueryParameter processValue(String name, String value) {
        return UriQueryParameter.of(name, value);
    }
}

