/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.securitygroups;

import java.util.Map;
import org.cloudfoundry.client.v3.securitygroups.BindRunningSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.BindRunningSecurityGroupResponse;
import org.cloudfoundry.client.v3.securitygroups.BindStagingSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.BindStagingSecurityGroupResponse;
import org.cloudfoundry.client.v3.securitygroups.CreateSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.CreateSecurityGroupResponse;
import org.cloudfoundry.client.v3.securitygroups.DeleteSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.GetSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.GetSecurityGroupResponse;
import org.cloudfoundry.client.v3.securitygroups.ListRunningSecurityGroupsRequest;
import org.cloudfoundry.client.v3.securitygroups.ListRunningSecurityGroupsResponse;
import org.cloudfoundry.client.v3.securitygroups.ListSecurityGroupsRequest;
import org.cloudfoundry.client.v3.securitygroups.ListSecurityGroupsResponse;
import org.cloudfoundry.client.v3.securitygroups.ListStagingSecurityGroupsRequest;
import org.cloudfoundry.client.v3.securitygroups.ListStagingSecurityGroupsResponse;
import org.cloudfoundry.client.v3.securitygroups.SecurityGroupsV3;
import org.cloudfoundry.client.v3.securitygroups.UnbindRunningSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.UnbindStagingSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.UpdateSecurityGroupRequest;
import org.cloudfoundry.client.v3.securitygroups.UpdateSecurityGroupResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorSecurityGroupsV3
extends AbstractClientV3Operations
implements SecurityGroupsV3 {
    public ReactorSecurityGroupsV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateSecurityGroupResponse> create(CreateSecurityGroupRequest request) {
        return this.post(request, CreateSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"security_groups"})).checkpoint();
    }

    public Mono<GetSecurityGroupResponse> get(GetSecurityGroupRequest request) {
        return this.get((Object)request, GetSecurityGroupResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<ListSecurityGroupsResponse> list(ListSecurityGroupsRequest request) {
        return this.get((Object)request, ListSecurityGroupsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"security_groups"})).checkpoint();
    }

    public Mono<UpdateSecurityGroupResponse> update(UpdateSecurityGroupRequest request) {
        return this.patch(request, UpdateSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<String> delete(DeleteSecurityGroupRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<BindRunningSecurityGroupResponse> bindRunningSecurityGroup(BindRunningSecurityGroupRequest request) {
        return this.post(request, BindRunningSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId(), "relationships", "running_spaces"})).checkpoint();
    }

    public Mono<BindStagingSecurityGroupResponse> bindStagingSecurityGroup(BindStagingSecurityGroupRequest request) {
        return this.post(request, BindStagingSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId(), "relationships", "staging_spaces"})).checkpoint();
    }

    public Mono<Void> unbindStagingSecurityGroup(UnbindStagingSecurityGroupRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId(), "relationships", "staging_spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<Void> unbindRunningSecurityGroup(UnbindRunningSecurityGroupRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId(), "relationships", "running_spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<ListRunningSecurityGroupsResponse> listRunning(ListRunningSecurityGroupsRequest request) {
        return this.get((Object)request, ListRunningSecurityGroupsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "running_security_groups"})).checkpoint();
    }

    public Mono<ListStagingSecurityGroupsResponse> listStaging(ListStagingSecurityGroupsRequest request) {
        return this.get((Object)request, ListStagingSecurityGroupsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"spaces", request.getSpaceId(), "staging_security_groups"})).checkpoint();
    }
}

