package org.cloudfoundry.reactor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _DelegatingUriQueryParameterBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DelegatingUriQueryParameterBuilder.builder()}.
 */
@Generated(from = "_DelegatingUriQueryParameterBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DelegatingUriQueryParameterBuilder
    extends org.cloudfoundry.reactor.util._DelegatingUriQueryParameterBuilder {
  private final List<UriQueryParameterBuilder> builders;

  private DelegatingUriQueryParameterBuilder(DelegatingUriQueryParameterBuilder.Builder builder) {
    this.builders = createUnmodifiableList(true, builder.builders);
  }

  /**
   * @return The value of the {@code builders} attribute
   */
  @Override
  public List<UriQueryParameterBuilder> getBuilders() {
    return builders;
  }

  /**
   * This instance is equal to all instances of {@code DelegatingUriQueryParameterBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DelegatingUriQueryParameterBuilder
        && equalTo(0, (DelegatingUriQueryParameterBuilder) another);
  }

  private boolean equalTo(int synthetic, DelegatingUriQueryParameterBuilder another) {
    return builders.equals(another.builders);
  }

  /**
   * Computes a hash code from attributes: {@code builders}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + builders.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DelegatingUriQueryParameterBuilder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DelegatingUriQueryParameterBuilder{"
        + "builders=" + builders
        + "}";
  }

  /**
   * Creates a builder for {@link DelegatingUriQueryParameterBuilder DelegatingUriQueryParameterBuilder}.
   * <pre>
   * DelegatingUriQueryParameterBuilder.builder()
   *    .builder|addAllBuilders(org.cloudfoundry.reactor.util.UriQueryParameterBuilder) // {@link _DelegatingUriQueryParameterBuilder#getBuilders() builders} elements
   *    .build();
   * </pre>
   * @return A new DelegatingUriQueryParameterBuilder builder
   */
  public static DelegatingUriQueryParameterBuilder.Builder builder() {
    return new DelegatingUriQueryParameterBuilder.Builder();
  }

  /**
   * Builds instances of type {@link DelegatingUriQueryParameterBuilder DelegatingUriQueryParameterBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DelegatingUriQueryParameterBuilder", generator = "Immutables")
  public static final class Builder {
    private List<UriQueryParameterBuilder> builders = new ArrayList<UriQueryParameterBuilder>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _DelegatingUriQueryParameterBuilder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_DelegatingUriQueryParameterBuilder instance) {
      Objects.requireNonNull(instance, "instance");
      addAllBuilders(instance.getBuilders());
      return this;
    }

    /**
     * Adds one element to {@link _DelegatingUriQueryParameterBuilder#getBuilders() builders} list.
     * @param element A builders element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder builder(UriQueryParameterBuilder element) {
      this.builders.add(Objects.requireNonNull(element, "builders element"));
      return this;
    }

    /**
     * Adds elements to {@link _DelegatingUriQueryParameterBuilder#getBuilders() builders} list.
     * @param elements An array of builders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder builders(UriQueryParameterBuilder... elements) {
      for (UriQueryParameterBuilder element : elements) {
        this.builders.add(Objects.requireNonNull(element, "builders element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link _DelegatingUriQueryParameterBuilder#getBuilders() builders} list.
     * @param elements An iterable of builders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder builders(Iterable<? extends UriQueryParameterBuilder> elements) {
      this.builders.clear();
      return addAllBuilders(elements);
    }

    /**
     * Adds elements to {@link _DelegatingUriQueryParameterBuilder#getBuilders() builders} list.
     * @param elements An iterable of builders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBuilders(Iterable<? extends UriQueryParameterBuilder> elements) {
      for (UriQueryParameterBuilder element : elements) {
        this.builders.add(Objects.requireNonNull(element, "builders element"));
      }
      return this;
    }

    /**
     * Builds a new {@link DelegatingUriQueryParameterBuilder DelegatingUriQueryParameterBuilder}.
     * @return An immutable instance of DelegatingUriQueryParameterBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DelegatingUriQueryParameterBuilder build() {
      return new DelegatingUriQueryParameterBuilder(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
