/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor.ConnectionContext;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

abstract class AbstractPayloadCachingRootProvider
extends AbstractRootProvider {
    private final ConcurrentMap<ConnectionContext, Mono<Map<String, String>>> payloads = new ConcurrentHashMap<ConnectionContext, Mono<Map<String, String>>>(1);

    AbstractPayloadCachingRootProvider() {
    }

    protected abstract Mono<Map<String, String>> doGetPayload(ConnectionContext var1);

    @Override
    protected final Mono<UriComponents> doGetRoot(String key, ConnectionContext connectionContext) {
        return this.payloads.computeIfAbsent(connectionContext, this::getPayload).map(payload -> {
            if (!payload.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Payload does not contain key '%s;", key));
            }
            return this.normalize(UriComponentsBuilder.fromUriString((String)((String)payload.get(key))));
        });
    }

    abstract ObjectMapper getObjectMapper();

    private Mono<Map<String, String>> getPayload(ConnectionContext connectionContext) {
        Mono<Map<String, String>> cached = this.doGetPayload(connectionContext);
        return connectionContext.getCacheDuration().map(arg_0 -> cached.cache(arg_0)).orElseGet(() -> cached.cache());
    }
}

