/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor._SingleEndpointRootProvider;
import org.immutables.value.Generated;

@Generated(from="_SingleEndpointRootProvider", generator="Immutables")
public final class SingleEndpointRootProvider
extends _SingleEndpointRootProvider {
    private final String apiHost;
    private final Integer port;
    private final Boolean secure;

    private SingleEndpointRootProvider(Builder builder) {
        this.apiHost = builder.apiHost;
        this.port = builder.port;
        this.secure = builder.secure;
    }

    @Override
    public String getApiHost() {
        return this.apiHost;
    }

    @Override
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    public Optional<Boolean> getSecure() {
        return Optional.ofNullable(this.secure);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SingleEndpointRootProvider && this.equalTo(0, (SingleEndpointRootProvider)another);
    }

    private boolean equalTo(int synthetic, SingleEndpointRootProvider another) {
        return this.apiHost.equals(another.apiHost) && Objects.equals(this.port, another.port) && Objects.equals(this.secure, another.secure);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.apiHost.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.secure);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SingleEndpointRootProvider{");
        builder.append("apiHost=").append(this.apiHost);
        if (this.port != null) {
            builder.append(", ");
            builder.append("port=").append(this.port);
        }
        if (this.secure != null) {
            builder.append(", ");
            builder.append("secure=").append(this.secure);
        }
        return builder.append("}").toString();
    }

    private static SingleEndpointRootProvider validate(SingleEndpointRootProvider instance) {
        instance.checkForValidApiHost();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_SingleEndpointRootProvider", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_API_HOST = 1L;
        private long initBits = 1L;
        private String apiHost;
        private Integer port;
        private Boolean secure;

        private Builder() {
        }

        public final Builder from(AbstractRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SingleEndpointRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_SingleEndpointRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<Integer> portOptional;
            Optional<Boolean> secureOptional;
            AbstractRootProvider instance;
            long bits = 0L;
            if (object instanceof AbstractRootProvider) {
                instance = (AbstractRootProvider)object;
                if ((bits & 2L) == 0L) {
                    secureOptional = instance.getSecure();
                    if (secureOptional.isPresent()) {
                        this.secure(secureOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    portOptional = instance.getPort();
                    if (portOptional.isPresent()) {
                        this.port(portOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.apiHost(instance.getApiHost());
                    bits |= 1L;
                }
            }
            if (object instanceof _SingleEndpointRootProvider) {
                instance = (_SingleEndpointRootProvider)object;
                if ((bits & 2L) == 0L) {
                    secureOptional = instance.getSecure();
                    if (secureOptional.isPresent()) {
                        this.secure(secureOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    portOptional = instance.getPort();
                    if (portOptional.isPresent()) {
                        this.port(portOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.apiHost(instance.getApiHost());
                    bits |= 1L;
                }
            }
        }

        public final Builder apiHost(String apiHost) {
            this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        public final Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public final Builder secure(Optional<Boolean> secure) {
            this.secure = secure.orElse(null);
            return this;
        }

        public SingleEndpointRootProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return SingleEndpointRootProvider.validate(new SingleEndpointRootProvider(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiHost");
            }
            return "Cannot build SingleEndpointRootProvider, some of required attributes are not set " + attributes;
        }
    }
}

