/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.servicebindings;

import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.client.v3.servicebindings.CreateServiceBindingRequest;
import org.cloudfoundry.client.v3.servicebindings.CreateServiceBindingResponse;
import org.cloudfoundry.client.v3.servicebindings.DeleteServiceBindingRequest;
import org.cloudfoundry.client.v3.servicebindings.GetServiceBindingDetailsRequest;
import org.cloudfoundry.client.v3.servicebindings.GetServiceBindingDetailsResponse;
import org.cloudfoundry.client.v3.servicebindings.GetServiceBindingParametersRequest;
import org.cloudfoundry.client.v3.servicebindings.GetServiceBindingParametersResponse;
import org.cloudfoundry.client.v3.servicebindings.GetServiceBindingRequest;
import org.cloudfoundry.client.v3.servicebindings.GetServiceBindingResponse;
import org.cloudfoundry.client.v3.servicebindings.ListServiceBindingsRequest;
import org.cloudfoundry.client.v3.servicebindings.ListServiceBindingsResponse;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingResource;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingsV3;
import org.cloudfoundry.client.v3.servicebindings.UpdateServiceBindingRequest;
import org.cloudfoundry.client.v3.servicebindings.UpdateServiceBindingResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorServiceBindingsV3
extends AbstractClientV3Operations
implements ServiceBindingsV3 {
    public ReactorServiceBindingsV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateServiceBindingResponse> create(CreateServiceBindingRequest request) {
        return this.postWithResponse(request, ServiceBindingResource.class, builder -> builder.pathSegment(new String[]{"service_credential_bindings"})).map(responseTuple -> CreateServiceBindingResponse.builder().serviceBinding(responseTuple.getBody()).jobId(Optional.ofNullable(ReactorServiceBindingsV3.extractJobId(responseTuple.getResponse()))).build()).checkpoint();
    }

    public Mono<String> delete(DeleteServiceBindingRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"service_credential_bindings", request.getServiceBindingId()})).checkpoint();
    }

    public Mono<GetServiceBindingResponse> get(GetServiceBindingRequest request) {
        return this.get((Object)request, GetServiceBindingResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_credential_bindings", request.getServiceBindingId()})).checkpoint();
    }

    public Mono<GetServiceBindingDetailsResponse> getDetails(GetServiceBindingDetailsRequest request) {
        return this.get((Object)request, GetServiceBindingDetailsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_credential_bindings", request.getServiceBindingId(), "details"})).checkpoint();
    }

    public Mono<GetServiceBindingParametersResponse> getParameters(GetServiceBindingParametersRequest request) {
        return this.get((Object)request, GetServiceBindingParametersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_credential_bindings", request.getServiceBindingId(), "parameters"})).checkpoint();
    }

    public Mono<ListServiceBindingsResponse> list(ListServiceBindingsRequest request) {
        return this.get((Object)request, ListServiceBindingsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_credential_bindings"})).checkpoint();
    }

    public Mono<UpdateServiceBindingResponse> update(UpdateServiceBindingRequest request) {
        return this.patch(request, UpdateServiceBindingResponse.class, builder -> builder.pathSegment(new String[]{"service_credential_bindings", request.getServiceBindingId()})).checkpoint();
    }
}

