/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.routing._ReactorRoutingClient;
import org.cloudfoundry.routing.v1.routergroups.RouterGroups;
import org.cloudfoundry.routing.v1.tcproutes.TcpRoutes;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

@Generated(from="_ReactorRoutingClient", generator="Immutables")
public final class ReactorRoutingClient
extends _ReactorRoutingClient {
    private final transient RouterGroups routerGroups;
    private final transient TcpRoutes tcpRoutes;
    private final ConnectionContext connectionContext;
    private final Map<String, String> requestTags;
    private final Mono<String> root;
    private final TokenProvider tokenProvider;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ReactorRoutingClient(Builder builder) {
        this.connectionContext = builder.connectionContext;
        this.tokenProvider = builder.tokenProvider;
        if (builder.requestTagsIsSet()) {
            this.initShim.requestTags(ReactorRoutingClient.createUnmodifiableMap(false, false, builder.requestTags));
        }
        if (builder.root != null) {
            this.initShim.root((Mono<String>)builder.root);
        }
        this.routerGroups = this.initShim.routerGroups();
        this.tcpRoutes = this.initShim.tcpRoutes();
        this.requestTags = this.initShim.getRequestTags();
        this.root = this.initShim.getRoot();
        this.initShim = null;
    }

    @Override
    public RouterGroups routerGroups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.routerGroups() : this.routerGroups;
    }

    @Override
    public TcpRoutes tcpRoutes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tcpRoutes() : this.tcpRoutes;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public Map<String, String> getRequestTags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRequestTags() : this.requestTags;
    }

    @Override
    public Mono<String> getRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoot() : this.root;
    }

    @Override
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReactorRoutingClient && this.equalTo(0, (ReactorRoutingClient)another);
    }

    private boolean equalTo(int synthetic, ReactorRoutingClient another) {
        return this.routerGroups.equals(another.routerGroups) && this.tcpRoutes.equals(another.tcpRoutes) && this.connectionContext.equals(another.connectionContext) && this.requestTags.equals(another.requestTags) && this.root.equals(another.root) && this.tokenProvider.equals(another.tokenProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.routerGroups.hashCode();
        h += (h << 5) + this.tcpRoutes.hashCode();
        h += (h << 5) + this.connectionContext.hashCode();
        h += (h << 5) + this.requestTags.hashCode();
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.tokenProvider.hashCode();
        return h;
    }

    public String toString() {
        return "ReactorRoutingClient{routerGroups=" + this.routerGroups + ", tcpRoutes=" + this.tcpRoutes + ", connectionContext=" + this.connectionContext + ", requestTags=" + this.requestTags + ", root=" + this.root + ", tokenProvider=" + this.tokenProvider + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ReactorRoutingClient", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_CONTEXT = 1L;
        private static final long INIT_BIT_TOKEN_PROVIDER = 2L;
        private static final long OPT_BIT_REQUEST_TAGS = 1L;
        private long initBits = 3L;
        private long optBits;
        private ConnectionContext connectionContext;
        private Map<String, String> requestTags = new LinkedHashMap<String, String>();
        private Mono<String> root;
        private TokenProvider tokenProvider;

        private Builder() {
        }

        public final Builder from(ReactorRoutingClient instance) {
            return this.from((_ReactorRoutingClient)instance);
        }

        final Builder from(_ReactorRoutingClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionContext(instance.getConnectionContext());
            this.putAllRequestTags(instance.getRequestTags());
            this.root(instance.getRoot());
            this.tokenProvider(instance.getTokenProvider());
            return this;
        }

        public final Builder connectionContext(ConnectionContext connectionContext) {
            this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder requestTag(String key, String value) {
            this.requestTags.put(Objects.requireNonNull(key, "requestTags key"), Objects.requireNonNull(value, value == null ? "requestTags value for key: " + key : null));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTag(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, v == null ? "requestTags value for key: " + k : null));
            this.optBits |= 1L;
            return this;
        }

        public final Builder requestTags(Map<String, ? extends String> entries) {
            this.requestTags.clear();
            this.optBits |= 1L;
            return this.putAllRequestTags(entries);
        }

        public final Builder putAllRequestTags(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.requestTags.put(Objects.requireNonNull(k, "requestTags key"), Objects.requireNonNull(v, v == null ? "requestTags value for key: " + k : null));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder root(Mono<String> root) {
            this.root = Objects.requireNonNull(root, "root");
            return this;
        }

        public final Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ReactorRoutingClient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReactorRoutingClient(this);
        }

        private boolean requestTagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenProvider");
            }
            return "Cannot build ReactorRoutingClient, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_ReactorRoutingClient", generator="Immutables")
    private final class InitShim {
        private byte routerGroupsBuildStage = 0;
        private RouterGroups routerGroups;
        private byte tcpRoutesBuildStage = 0;
        private TcpRoutes tcpRoutes;
        private byte requestTagsBuildStage = 0;
        private Map<String, String> requestTags;
        private byte rootBuildStage = 0;
        private Mono<String> root;

        private InitShim() {
        }

        RouterGroups routerGroups() {
            if (this.routerGroupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.routerGroupsBuildStage == 0) {
                this.routerGroupsBuildStage = (byte)-1;
                this.routerGroups = Objects.requireNonNull(ReactorRoutingClient.super.routerGroups(), "routerGroups");
                this.routerGroupsBuildStage = 1;
            }
            return this.routerGroups;
        }

        TcpRoutes tcpRoutes() {
            if (this.tcpRoutesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tcpRoutesBuildStage == 0) {
                this.tcpRoutesBuildStage = (byte)-1;
                this.tcpRoutes = Objects.requireNonNull(ReactorRoutingClient.super.tcpRoutes(), "tcpRoutes");
                this.tcpRoutesBuildStage = 1;
            }
            return this.tcpRoutes;
        }

        Map<String, String> getRequestTags() {
            if (this.requestTagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestTagsBuildStage == 0) {
                this.requestTagsBuildStage = (byte)-1;
                this.requestTags = ReactorRoutingClient.createUnmodifiableMap(true, false, ReactorRoutingClient.super.getRequestTags());
                this.requestTagsBuildStage = 1;
            }
            return this.requestTags;
        }

        void requestTags(Map<String, String> requestTags) {
            this.requestTags = requestTags;
            this.requestTagsBuildStage = 1;
        }

        Mono<String> getRoot() {
            if (this.rootBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootBuildStage == 0) {
                this.rootBuildStage = (byte)-1;
                this.root = Objects.requireNonNull(ReactorRoutingClient.super.getRoot(), "root");
                this.rootBuildStage = 1;
            }
            return this.root;
        }

        void root(Mono<String> root) {
            this.root = root;
            this.rootBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.routerGroupsBuildStage == -1) {
                attributes.add("routerGroups");
            }
            if (this.tcpRoutesBuildStage == -1) {
                attributes.add("tcpRoutes");
            }
            if (this.requestTagsBuildStage == -1) {
                attributes.add("requestTags");
            }
            if (this.rootBuildStage == -1) {
                attributes.add("root");
            }
            return "Cannot build ReactorRoutingClient, attribute initializers form cycle " + attributes;
        }
    }
}

