/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.reactor._ProxyConfiguration;
import org.immutables.value.Generated;

@Generated(from="_ProxyConfiguration", generator="Immutables")
public final class ProxyConfiguration
extends _ProxyConfiguration {
    private final String host;
    private final String password;
    private final Integer port;
    private final String username;

    private ProxyConfiguration(Builder builder) {
        this.host = builder.host;
        this.password = builder.password;
        this.port = builder.port;
        this.username = builder.username;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Override
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProxyConfiguration && this.equalTo(0, (ProxyConfiguration)another);
    }

    private boolean equalTo(int synthetic, ProxyConfiguration another) {
        return this.host.equals(another.host) && Objects.equals(this.password, another.password) && Objects.equals(this.port, another.port) && Objects.equals(this.username, another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.username);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProxyConfiguration{");
        builder.append("host=").append(this.host);
        if (this.password != null) {
            builder.append(", ");
            builder.append("password=").append(this.password);
        }
        if (this.port != null) {
            builder.append(", ");
            builder.append("port=").append(this.port);
        }
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ProxyConfiguration", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private long initBits = 1L;
        private String host;
        private String password;
        private Integer port;
        private String username;

        private Builder() {
        }

        public final Builder from(ProxyConfiguration instance) {
            return this.from((_ProxyConfiguration)instance);
        }

        final Builder from(_ProxyConfiguration instance) {
            Optional<String> usernameOptional;
            Optional<Integer> portOptional;
            Objects.requireNonNull(instance, "instance");
            this.host(instance.getHost());
            Optional<String> passwordOptional = instance.getPassword();
            if (passwordOptional.isPresent()) {
                this.password(passwordOptional);
            }
            if ((portOptional = instance.getPort()).isPresent()) {
                this.port(portOptional);
            }
            if ((usernameOptional = instance.getUsername()).isPresent()) {
                this.username(usernameOptional);
            }
            return this;
        }

        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        public final Builder password(Optional<String> password) {
            this.password = password.orElse(null);
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder username(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public ProxyConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ProxyConfiguration(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            return "Cannot build ProxyConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

