/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.serviceinstances;

import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.client.v3.serviceinstances.CreateServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceinstances.CreateServiceInstanceResponse;
import org.cloudfoundry.client.v3.serviceinstances.DeleteServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceinstances.GetManagedServiceParametersRequest;
import org.cloudfoundry.client.v3.serviceinstances.GetManagedServiceParametersResponse;
import org.cloudfoundry.client.v3.serviceinstances.GetServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceinstances.GetServiceInstanceResponse;
import org.cloudfoundry.client.v3.serviceinstances.GetUserProvidedCredentialsRequest;
import org.cloudfoundry.client.v3.serviceinstances.GetUserProvidedCredentialsResponse;
import org.cloudfoundry.client.v3.serviceinstances.ListServiceInstancesRequest;
import org.cloudfoundry.client.v3.serviceinstances.ListServiceInstancesResponse;
import org.cloudfoundry.client.v3.serviceinstances.ListSharedSpacesRelationshipRequest;
import org.cloudfoundry.client.v3.serviceinstances.ListSharedSpacesRelationshipResponse;
import org.cloudfoundry.client.v3.serviceinstances.ServiceInstanceResource;
import org.cloudfoundry.client.v3.serviceinstances.ServiceInstancesV3;
import org.cloudfoundry.client.v3.serviceinstances.ShareServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceinstances.ShareServiceInstanceResponse;
import org.cloudfoundry.client.v3.serviceinstances.UnshareServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceinstances.UpdateServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceinstances.UpdateServiceInstanceResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.HttpClientResponseWithParsedBody;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorServiceInstancesV3
extends AbstractClientV3Operations
implements ServiceInstancesV3 {
    public ReactorServiceInstancesV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateServiceInstanceResponse> create(CreateServiceInstanceRequest request) {
        return this.postWithResponse(request, ServiceInstanceResource.class, builder -> builder.pathSegment(new String[]{"service_instances"})).map(responseTuple -> CreateServiceInstanceResponse.builder().jobId(this.getJobId((HttpClientResponseWithParsedBody)responseTuple)).serviceInstance(responseTuple.getBody()).build()).checkpoint();
    }

    private <T> Optional<String> getJobId(HttpClientResponseWithParsedBody<T> responseTuple) {
        return Optional.ofNullable(ReactorServiceInstancesV3.extractJobId(responseTuple.getResponse()));
    }

    public Mono<GetServiceInstanceResponse> get(GetServiceInstanceRequest request) {
        return this.get((Object)request, GetServiceInstanceResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId()})).checkpoint();
    }

    public Mono<Optional<String>> delete(DeleteServiceInstanceRequest request) {
        return this.deleteWithResponse(request, String.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId()})).map(this::getJobId).checkpoint();
    }

    public Mono<GetManagedServiceParametersResponse> getManagedServiceParameters(GetManagedServiceParametersRequest request) {
        return this.get((Object)request, GetManagedServiceParametersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "parameters"})).checkpoint();
    }

    public Mono<GetUserProvidedCredentialsResponse> getUserProvidedCredentials(GetUserProvidedCredentialsRequest request) {
        return this.get((Object)request, GetUserProvidedCredentialsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "credentials"})).checkpoint();
    }

    public Mono<ListServiceInstancesResponse> list(ListServiceInstancesRequest request) {
        return this.get((Object)request, ListServiceInstancesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances"})).checkpoint();
    }

    public Mono<ListSharedSpacesRelationshipResponse> listSharedSpacesRelationship(ListSharedSpacesRelationshipRequest request) {
        return this.get((Object)request, ListSharedSpacesRelationshipResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces"})).checkpoint();
    }

    public Mono<ShareServiceInstanceResponse> share(ShareServiceInstanceRequest request) {
        return this.post(request, ShareServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces"})).checkpoint();
    }

    public Mono<Void> unshare(UnshareServiceInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<UpdateServiceInstanceResponse> update(UpdateServiceInstanceRequest request) {
        return this.patchWithResponse(request, ServiceInstanceResource.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId()})).map(responseTuple -> UpdateServiceInstanceResponse.builder().jobId(this.getJobId((HttpClientResponseWithParsedBody)responseTuple)).serviceInstance(responseTuple.getBody()).build()).checkpoint();
    }
}

