package org.cloudfoundry.reactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

/**
 * Immutable implementation of {@link _HttpClientResponseWithConnection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code HttpClientResponseWithConnection.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code HttpClientResponseWithConnection.of()}.
 */
@Generated(from = "_HttpClientResponseWithConnection", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class HttpClientResponseWithConnection
    implements org.cloudfoundry.reactor._HttpClientResponseWithConnection {
  private final Connection connection;
  private final HttpClientResponse response;

  private HttpClientResponseWithConnection(Connection connection, HttpClientResponse response) {
    this.connection = Objects.requireNonNull(connection, "connection");
    this.response = Objects.requireNonNull(response, "response");
  }

  private HttpClientResponseWithConnection(HttpClientResponseWithConnection.Builder builder) {
    this.connection = builder.connection;
    this.response = builder.response;
  }

  /**
   * @return The value of the {@code connection} attribute
   */
  @Override
  public Connection getConnection() {
    return connection;
  }

  /**
   * @return The value of the {@code response} attribute
   */
  @Override
  public HttpClientResponse getResponse() {
    return response;
  }

  /**
   * This instance is equal to all instances of {@code HttpClientResponseWithConnection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof HttpClientResponseWithConnection
        && equalTo(0, (HttpClientResponseWithConnection) another);
  }

  private boolean equalTo(int synthetic, HttpClientResponseWithConnection another) {
    return connection.equals(another.connection)
        && response.equals(another.response);
  }

  /**
   * Computes a hash code from attributes: {@code connection}, {@code response}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + connection.hashCode();
    h += (h << 5) + response.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpClientResponseWithConnection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HttpClientResponseWithConnection{"
        + "connection=" + connection
        + ", response=" + response
        + "}";
  }

  /**
   * Construct a new immutable {@code HttpClientResponseWithConnection} instance.
   * @param connection The value for the {@code connection} attribute
   * @param response The value for the {@code response} attribute
   * @return An immutable HttpClientResponseWithConnection instance
   */
  public static HttpClientResponseWithConnection of(Connection connection, HttpClientResponse response) {
    return new HttpClientResponseWithConnection(connection, response);
  }

  /**
   * Creates a builder for {@link HttpClientResponseWithConnection HttpClientResponseWithConnection}.
   * <pre>
   * HttpClientResponseWithConnection.builder()
   *    .connection(reactor.netty.Connection) // required {@link _HttpClientResponseWithConnection#getConnection() connection}
   *    .response(reactor.netty.http.client.HttpClientResponse) // required {@link _HttpClientResponseWithConnection#getResponse() response}
   *    .build();
   * </pre>
   * @return A new HttpClientResponseWithConnection builder
   */
  public static HttpClientResponseWithConnection.Builder builder() {
    return new HttpClientResponseWithConnection.Builder();
  }

  /**
   * Builds instances of type {@link HttpClientResponseWithConnection HttpClientResponseWithConnection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_HttpClientResponseWithConnection", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION = 0x1L;
    private static final long INIT_BIT_RESPONSE = 0x2L;
    private long initBits = 0x3L;

    private Connection connection;
    private HttpClientResponse response;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _HttpClientResponseWithConnection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_HttpClientResponseWithConnection instance) {
      Objects.requireNonNull(instance, "instance");
      this.connection(instance.getConnection());
      this.response(instance.getResponse());
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpClientResponseWithConnection#getConnection() connection} attribute.
     * @param connection The value for connection 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connection(Connection connection) {
      this.connection = Objects.requireNonNull(connection, "connection");
      initBits &= ~INIT_BIT_CONNECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpClientResponseWithConnection#getResponse() response} attribute.
     * @param response The value for response 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder response(HttpClientResponse response) {
      this.response = Objects.requireNonNull(response, "response");
      initBits &= ~INIT_BIT_RESPONSE;
      return this;
    }

    /**
     * Builds a new {@link HttpClientResponseWithConnection HttpClientResponseWithConnection}.
     * @return An immutable instance of HttpClientResponseWithConnection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HttpClientResponseWithConnection build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new HttpClientResponseWithConnection(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION) != 0) attributes.add("connection");
      if ((initBits & INIT_BIT_RESPONSE) != 0) attributes.add("response");
      return "Cannot build HttpClientResponseWithConnection, some of required attributes are not set " + attributes;
    }
  }
}
