package org.cloudfoundry.reactor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _OperatorContext}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code OperatorContext.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code OperatorContext.of()}.
 */
@Generated(from = "_OperatorContext", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OperatorContext implements org.cloudfoundry.reactor.util._OperatorContext {
  private final ConnectionContext connectionContext;
  private final ErrorPayloadMapper errorPayloadMapper;
  private final String root;
  private final TokenProvider tokenProvider;

  private OperatorContext(ConnectionContext connectionContext, String root) {
    this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
    this.root = Objects.requireNonNull(root, "root");
    this.errorPayloadMapper = null;
    this.tokenProvider = null;
  }

  private OperatorContext(
      ConnectionContext connectionContext,
      ErrorPayloadMapper errorPayloadMapper,
      String root,
      TokenProvider tokenProvider) {
    this.connectionContext = connectionContext;
    this.errorPayloadMapper = errorPayloadMapper;
    this.root = root;
    this.tokenProvider = tokenProvider;
  }

  /**
   * @return The value of the {@code connectionContext} attribute
   */
  @Override
  public ConnectionContext getConnectionContext() {
    return connectionContext;
  }

  /**
   * @return The value of the {@code errorPayloadMapper} attribute
   */
  @Override
  public Optional<ErrorPayloadMapper> getErrorPayloadMapper() {
    return Optional.ofNullable(errorPayloadMapper);
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public String getRoot() {
    return root;
  }

  /**
   * @return The value of the {@code tokenProvider} attribute
   */
  @Override
  public Optional<TokenProvider> getTokenProvider() {
    return Optional.ofNullable(tokenProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link _OperatorContext#getConnectionContext() connectionContext} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionContext
   * @return A modified copy of the {@code this} object
   */
  public final OperatorContext withConnectionContext(ConnectionContext value) {
    if (this.connectionContext == value) return this;
    ConnectionContext newValue = Objects.requireNonNull(value, "connectionContext");
    return new OperatorContext(newValue, this.errorPayloadMapper, this.root, this.tokenProvider);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link _OperatorContext#getErrorPayloadMapper() errorPayloadMapper} attribute.
   * @param value The value for errorPayloadMapper
   * @return A modified copy of {@code this} object
   */
  public final OperatorContext withErrorPayloadMapper(ErrorPayloadMapper value) {
    ErrorPayloadMapper newValue = Objects.requireNonNull(value, "errorPayloadMapper");
    if (this.errorPayloadMapper == newValue) return this;
    return new OperatorContext(this.connectionContext, newValue, this.root, this.tokenProvider);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link _OperatorContext#getErrorPayloadMapper() errorPayloadMapper} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for errorPayloadMapper
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final OperatorContext withErrorPayloadMapper(Optional<? extends ErrorPayloadMapper> optional) {
    ErrorPayloadMapper value = optional.orElse(null);
    if (this.errorPayloadMapper == value) return this;
    return new OperatorContext(this.connectionContext, value, this.root, this.tokenProvider);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link _OperatorContext#getRoot() root} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for root
   * @return A modified copy of the {@code this} object
   */
  public final OperatorContext withRoot(String value) {
    String newValue = Objects.requireNonNull(value, "root");
    if (this.root.equals(newValue)) return this;
    return new OperatorContext(this.connectionContext, this.errorPayloadMapper, newValue, this.tokenProvider);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link _OperatorContext#getTokenProvider() tokenProvider} attribute.
   * @param value The value for tokenProvider
   * @return A modified copy of {@code this} object
   */
  public final OperatorContext withTokenProvider(TokenProvider value) {
    TokenProvider newValue = Objects.requireNonNull(value, "tokenProvider");
    if (this.tokenProvider == newValue) return this;
    return new OperatorContext(this.connectionContext, this.errorPayloadMapper, this.root, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link _OperatorContext#getTokenProvider() tokenProvider} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tokenProvider
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final OperatorContext withTokenProvider(Optional<? extends TokenProvider> optional) {
    TokenProvider value = optional.orElse(null);
    if (this.tokenProvider == value) return this;
    return new OperatorContext(this.connectionContext, this.errorPayloadMapper, this.root, value);
  }

  /**
   * This instance is equal to all instances of {@code OperatorContext} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OperatorContext
        && equalTo(0, (OperatorContext) another);
  }

  private boolean equalTo(int synthetic, OperatorContext another) {
    return connectionContext.equals(another.connectionContext)
        && Objects.equals(errorPayloadMapper, another.errorPayloadMapper)
        && root.equals(another.root)
        && Objects.equals(tokenProvider, another.tokenProvider);
  }

  /**
   * Computes a hash code from attributes: {@code connectionContext}, {@code errorPayloadMapper}, {@code root}, {@code tokenProvider}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + connectionContext.hashCode();
    h += (h << 5) + Objects.hashCode(errorPayloadMapper);
    h += (h << 5) + root.hashCode();
    h += (h << 5) + Objects.hashCode(tokenProvider);
    return h;
  }

  /**
   * Prints the immutable value {@code OperatorContext} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("OperatorContext{");
    builder.append("connectionContext=").append(connectionContext);
    if (errorPayloadMapper != null) {
      builder.append(", ");
      builder.append("errorPayloadMapper=").append(errorPayloadMapper);
    }
    builder.append(", ");
    builder.append("root=").append(root);
    if (tokenProvider != null) {
      builder.append(", ");
      builder.append("tokenProvider=").append(tokenProvider);
    }
    return builder.append("}").toString();
  }

  /**
   * Construct a new immutable {@code OperatorContext} instance.
   * @param connectionContext The value for the {@code connectionContext} attribute
   * @param root The value for the {@code root} attribute
   * @return An immutable OperatorContext instance
   */
  public static OperatorContext of(ConnectionContext connectionContext, String root) {
    return new OperatorContext(connectionContext, root);
  }

  /**
   * Creates an immutable copy of a {@link _OperatorContext} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OperatorContext instance
   */
  public static OperatorContext copyOf(_OperatorContext instance) {
    if (instance instanceof OperatorContext) {
      return (OperatorContext) instance;
    }
    return OperatorContext.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link OperatorContext OperatorContext}.
   * <pre>
   * OperatorContext.builder()
   *    .connectionContext(org.cloudfoundry.reactor.ConnectionContext) // required {@link _OperatorContext#getConnectionContext() connectionContext}
   *    .errorPayloadMapper(org.cloudfoundry.reactor.util.ErrorPayloadMapper) // optional {@link _OperatorContext#getErrorPayloadMapper() errorPayloadMapper}
   *    .root(String) // required {@link _OperatorContext#getRoot() root}
   *    .tokenProvider(org.cloudfoundry.reactor.TokenProvider) // optional {@link _OperatorContext#getTokenProvider() tokenProvider}
   *    .build();
   * </pre>
   * @return A new OperatorContext builder
   */
  public static OperatorContext.Builder builder() {
    return new OperatorContext.Builder();
  }

  /**
   * Builds instances of type {@link OperatorContext OperatorContext}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OperatorContext", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_CONTEXT = 0x1L;
    private static final long INIT_BIT_ROOT = 0x2L;
    private long initBits = 0x3L;

    private ConnectionContext connectionContext;
    private ErrorPayloadMapper errorPayloadMapper;
    private String root;
    private TokenProvider tokenProvider;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _OperatorContext} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_OperatorContext instance) {
      Objects.requireNonNull(instance, "instance");
      this.connectionContext(instance.getConnectionContext());
      Optional<ErrorPayloadMapper> errorPayloadMapperOptional = instance.getErrorPayloadMapper();
      if (errorPayloadMapperOptional.isPresent()) {
        errorPayloadMapper(errorPayloadMapperOptional);
      }
      this.root(instance.getRoot());
      Optional<TokenProvider> tokenProviderOptional = instance.getTokenProvider();
      if (tokenProviderOptional.isPresent()) {
        tokenProvider(tokenProviderOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _OperatorContext#getConnectionContext() connectionContext} attribute.
     * @param connectionContext The value for connectionContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionContext(ConnectionContext connectionContext) {
      this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
      initBits &= ~INIT_BIT_CONNECTION_CONTEXT;
      return this;
    }

    /**
     * Initializes the optional value {@link _OperatorContext#getErrorPayloadMapper() errorPayloadMapper} to errorPayloadMapper.
     * @param errorPayloadMapper The value for errorPayloadMapper
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorPayloadMapper(ErrorPayloadMapper errorPayloadMapper) {
      this.errorPayloadMapper = Objects.requireNonNull(errorPayloadMapper, "errorPayloadMapper");
      return this;
    }

    /**
     * Initializes the optional value {@link _OperatorContext#getErrorPayloadMapper() errorPayloadMapper} to errorPayloadMapper.
     * @param errorPayloadMapper The value for errorPayloadMapper
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errorPayloadMapper(Optional<? extends ErrorPayloadMapper> errorPayloadMapper) {
      this.errorPayloadMapper = errorPayloadMapper.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link _OperatorContext#getRoot() root} attribute.
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(String root) {
      this.root = Objects.requireNonNull(root, "root");
      initBits &= ~INIT_BIT_ROOT;
      return this;
    }

    /**
     * Initializes the optional value {@link _OperatorContext#getTokenProvider() tokenProvider} to tokenProvider.
     * @param tokenProvider The value for tokenProvider
     * @return {@code this} builder for chained invocation
     */
    public final Builder tokenProvider(TokenProvider tokenProvider) {
      this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
      return this;
    }

    /**
     * Initializes the optional value {@link _OperatorContext#getTokenProvider() tokenProvider} to tokenProvider.
     * @param tokenProvider The value for tokenProvider
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenProvider(Optional<? extends TokenProvider> tokenProvider) {
      this.tokenProvider = tokenProvider.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link OperatorContext OperatorContext}.
     * @return An immutable instance of OperatorContext
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OperatorContext build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OperatorContext(connectionContext, errorPayloadMapper, root, tokenProvider);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_CONTEXT) != 0) attributes.add("connectionContext");
      if ((initBits & INIT_BIT_ROOT) != 0) attributes.add("root");
      return "Cannot build OperatorContext, some of required attributes are not set " + attributes;
    }
  }
}
