/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.uaa.tokens.ListTokenKeysRequest;
import org.cloudfoundry.uaa.tokens.ListTokenKeysResponse;
import org.cloudfoundry.uaa.tokens.TokenKey;
import org.cloudfoundry.uaa.tokens.Tokens;
import reactor.core.Exceptions;

final class UaaSigningKeyResolver
implements SigningKeyResolver {
    private static final String BEGIN = "-----BEGIN PUBLIC KEY-----";
    private static final String END = "-----END PUBLIC KEY-----";
    private final Object monitor = new Object();
    private final Map<String, Key> signingKeys = new HashMap<String, Key>();
    private final Tokens tokens;

    UaaSigningKeyResolver(Tokens tokens) {
        this.tokens = tokens;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header.getKeyId());
    }

    public Key resolveSigningKey(JwsHeader jwsHeader, byte[] bytes) {
        return this.getKey(jwsHeader.getKeyId());
    }

    private static byte[] decode(TokenKey tokenKey) {
        return Base64.getMimeDecoder().decode(tokenKey.getValue().replace(BEGIN, "").replace(END, "").trim());
    }

    private static Key generateKey(TokenKey tokenKey) {
        try {
            return KeyFactory.getInstance(tokenKey.getKeyType().toString()).generatePublic(new X509EncodedKeySpec(UaaSigningKeyResolver.decode(tokenKey)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Key getKey(String keyId) {
        Object object = this.monitor;
        synchronized (object) {
            Key key = this.signingKeys.get(keyId);
            if (key != null) {
                return key;
            }
            this.refreshKeys();
            key = this.signingKeys.get(keyId);
            if (key != null) {
                return key;
            }
            throw new IllegalStateException(String.format("Unable to retrieve signing key %s", keyId));
        }
    }

    private void refreshKeys() {
        this.signingKeys.clear();
        this.signingKeys.putAll((Map)this.tokens.listKeys(ListTokenKeysRequest.builder().build()).flatMapIterable(ListTokenKeysResponse::getKeys).collectMap(TokenKey::getId, UaaSigningKeyResolver::generateKey).block(Duration.ofMinutes(5L)));
    }
}

