/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.json.JsonObjectDecoder;
import java.nio.charset.Charset;
import java.util.function.BiFunction;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.cloudfoundry.reactor.util.JsonParsingException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClientRequest;

public final class JsonCodec {
    private static final int MAX_PAYLOAD_SIZE = 0x6400000;

    public static <T> Mono<T> decode(ObjectMapper objectMapper, ByteBufFlux responseBody, Class<T> responseType) {
        return responseBody.aggregate().asByteArray().map(payload -> {
            try {
                return objectMapper.readValue(payload, responseType);
            }
            catch (Throwable t) {
                throw new JsonParsingException(t.getMessage(), t, new String((byte[])payload, Charset.defaultCharset()));
            }
        });
    }

    public static void setDecodeHeaders(HttpHeaders httpHeaders) {
        httpHeaders.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)HttpHeaderValues.APPLICATION_JSON);
    }

    static JsonObjectDecoder createDecoder() {
        return new JsonObjectDecoder(0x6400000);
    }

    static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> encode(ObjectMapper objectMapper, Object requestPayload) {
        if (!AnnotationUtils.findAnnotation(requestPayload.getClass(), JsonSerialize.class).isPresent()) {
            return (request, outbound) -> Mono.empty();
        }
        return (request, outbound) -> {
            try {
                byte[] bytes = objectMapper.writeValueAsBytes(requestPayload);
                String contentLength = String.valueOf(bytes.length);
                Mono body = Mono.just((Object)bytes);
                request.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)contentLength);
                request.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
                return outbound.sendByteArray((Publisher)body);
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        };
    }
}

