package org.cloudfoundry.reactor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UriQueryParameter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UriQueryParameter.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code UriQueryParameter.of()}.
 */
@Generated(from = "_UriQueryParameter", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UriQueryParameter implements org.cloudfoundry.reactor.util._UriQueryParameter {
  private final String key;
  private final Object value;

  private UriQueryParameter(String key, Object value) {
    this.key = Objects.requireNonNull(key, "key");
    this.value = Objects.requireNonNull(value, "value");
  }

  private UriQueryParameter(UriQueryParameter.Builder builder) {
    this.key = builder.key;
    this.value = builder.value;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String getKey() {
    return key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Object getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code UriQueryParameter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UriQueryParameter
        && equalTo((UriQueryParameter) another);
  }

  private boolean equalTo(UriQueryParameter another) {
    return key.equals(another.key)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UriQueryParameter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UriQueryParameter{"
        + "key=" + key
        + ", value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code UriQueryParameter} instance.
   * @param key The value for the {@code key} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable UriQueryParameter instance
   */
  public static UriQueryParameter of(String key, Object value) {
    return new UriQueryParameter(key, value);
  }

  /**
   * Creates a builder for {@link UriQueryParameter UriQueryParameter}.
   * <pre>
   * UriQueryParameter.builder()
   *    .key(String) // required {@link _UriQueryParameter#getKey() key}
   *    .value(Object) // required {@link _UriQueryParameter#getValue() value}
   *    .build();
   * </pre>
   * @return A new UriQueryParameter builder
   */
  public static UriQueryParameter.Builder builder() {
    return new UriQueryParameter.Builder();
  }

  /**
   * Builds instances of type {@link UriQueryParameter UriQueryParameter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UriQueryParameter", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private String key;
    private Object value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _UriQueryParameter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UriQueryParameter instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.getKey());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link _UriQueryParameter#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link _UriQueryParameter#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(Object value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link UriQueryParameter UriQueryParameter}.
     * @return An immutable instance of UriQueryParameter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UriQueryParameter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UriQueryParameter(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build UriQueryParameter, some of required attributes are not set " + attributes;
    }
  }
}
