package org.cloudfoundry.reactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.netty.http.client.HttpClientResponse;

/**
 * Immutable implementation of {@link _HttpClientResponseWithParsedBody}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code HttpClientResponseWithParsedBody.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code HttpClientResponseWithParsedBody.of()}.
 */
@Generated(from = "_HttpClientResponseWithParsedBody", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class HttpClientResponseWithParsedBody<T>
    implements org.cloudfoundry.reactor._HttpClientResponseWithParsedBody<T> {
  private final T body;
  private final HttpClientResponse response;

  @SuppressWarnings("unchecked") // safe covariant cast
  private HttpClientResponseWithParsedBody(Optional<? extends T> body, HttpClientResponse response) {
    this.body = body.orElse(null);
    this.response = Objects.requireNonNull(response, "response");
  }

  private HttpClientResponseWithParsedBody(HttpClientResponseWithParsedBody.Builder<T> builder) {
    this.body = builder.body;
    this.response = builder.response;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @Override
  public Optional<T> getBody() {
    return Optional.ofNullable(body);
  }

  /**
   * @return The value of the {@code response} attribute
   */
  @Override
  public HttpClientResponse getResponse() {
    return response;
  }

  /**
   * This instance is equal to all instances of {@code HttpClientResponseWithParsedBody} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof HttpClientResponseWithParsedBody<?>
        && equalTo((HttpClientResponseWithParsedBody<?>) another);
  }

  private boolean equalTo(HttpClientResponseWithParsedBody<?> another) {
    return Objects.equals(body, another.body)
        && response.equals(another.response);
  }

  /**
   * Computes a hash code from attributes: {@code body}, {@code response}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + response.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpClientResponseWithParsedBody} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("HttpClientResponseWithParsedBody{");
    if (body != null) {
      builder.append("body=").append(body);
    }
    if (builder.length() > 33) builder.append(", ");
    builder.append("response=").append(response);
    return builder.append("}").toString();
  }

  /**
   * Construct a new immutable {@code HttpClientResponseWithParsedBody} instance.
 * @param <T> generic parameter T
   * @param body The value for the {@code body} attribute
   * @param response The value for the {@code response} attribute
   * @return An immutable HttpClientResponseWithParsedBody instance
   */
  public static <T> HttpClientResponseWithParsedBody<T> of(Optional<? extends T> body, HttpClientResponse response) {
    return new HttpClientResponseWithParsedBody<>(body, response);
  }

  /**
   * Creates a builder for {@link HttpClientResponseWithParsedBody HttpClientResponseWithParsedBody}.
   * <pre>
   * HttpClientResponseWithParsedBody.&amp;lt;T&amp;gt;builder()
   *    .body(T) // optional {@link _HttpClientResponseWithParsedBody#getBody() body}
   *    .response(reactor.netty.http.client.HttpClientResponse) // required {@link _HttpClientResponseWithParsedBody#getResponse() response}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new HttpClientResponseWithParsedBody builder
   */
  public static <T> HttpClientResponseWithParsedBody.Builder<T> builder() {
    return new HttpClientResponseWithParsedBody.Builder<>();
  }

  /**
   * Builds instances of type {@link HttpClientResponseWithParsedBody HttpClientResponseWithParsedBody}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_HttpClientResponseWithParsedBody", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_RESPONSE = 0x1L;
    private long initBits = 0x1L;

    private T body;
    private HttpClientResponse response;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code _HttpClientResponseWithParsedBody} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(_HttpClientResponseWithParsedBody<T> instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<T> bodyOptional = instance.getBody();
      if (bodyOptional.isPresent()) {
        body(bodyOptional);
      }
      response(instance.getResponse());
      return this;
    }

    /**
     * Initializes the optional value {@link _HttpClientResponseWithParsedBody#getBody() body} to body.
     * @param body The value for body
     * @return {@code this} builder for chained invocation
     */
    public final Builder<T> body(T body) {
      this.body = Objects.requireNonNull(body, "body");
      return this;
    }

    /**
     * Initializes the optional value {@link _HttpClientResponseWithParsedBody#getBody() body} to body.
     * @param body The value for body
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> body(Optional<? extends T> body) {
      this.body = body.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpClientResponseWithParsedBody#getResponse() response} attribute.
     * @param response The value for response 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> response(HttpClientResponse response) {
      this.response = Objects.requireNonNull(response, "response");
      initBits &= ~INIT_BIT_RESPONSE;
      return this;
    }

    /**
     * Builds a new {@link HttpClientResponseWithParsedBody HttpClientResponseWithParsedBody}.
     * @return An immutable instance of HttpClientResponseWithParsedBody
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HttpClientResponseWithParsedBody<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new HttpClientResponseWithParsedBody<T>(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RESPONSE) != 0) attributes.add("response");
      return "Cannot build HttpClientResponseWithParsedBody, some of required attributes are not set " + attributes;
    }
  }
}
