/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor.ConnectionContext;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Value.Immutable
abstract class _RootPayloadRootProvider
extends AbstractRootProvider {
    _RootPayloadRootProvider() {
    }

    @Override
    protected Mono<UriComponents> doGetRoot(ConnectionContext connectionContext) {
        return Mono.just((Object)this.getRoot());
    }

    @Override
    protected Mono<UriComponents> doGetRoot(String key, ConnectionContext connectionContext) {
        return this.getPayload(connectionContext).map(payload -> {
            if (!payload.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Root payload does not contain key '%s'", key));
            }
            return this.normalize(UriComponentsBuilder.fromUriString((String)((String)payload.get(key))));
        });
    }

    abstract ObjectMapper getObjectMapper();

    @Value.Derived
    private Mono<Map<String, String>> getPayload(ConnectionContext connectionContext) {
        return this.createOperator(connectionContext).flatMap(operator -> operator.get().uri(Function.identity()).response().parseBody(Map.class)).map(payload -> payload).map(this::processPayload).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Root endpoint does not contain a payload"))).checkpoint();
    }

    private Map<String, String> processPayload(Map<String, Map<String, Map<String, String>>> payload) {
        return payload.get("links").entrySet().stream().filter(item -> null != item.getValue()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((Map)entry.getValue()).get("href")));
    }
}

