package org.cloudfoundry.client.v2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The metadata payload for a resource
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Metadata", generator = "Immutables")
public final class Metadata extends org.cloudfoundry.client.v2._Metadata {
  private final @Nullable String createdAt;
  private final @Nullable String id;
  private final @Nullable String updatedAt;
  private final @Nullable String url;

  private Metadata(Metadata.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.updatedAt = builder.updatedAt;
    this.url = builder.url;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The resource's URL
   */
  @JsonProperty("url")
  @Override
  public @Nullable String getUrl() {
    return url;
  }

  /**
   * This instance is equal to all instances of {@code Metadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Metadata
        && equalTo((Metadata) another);
  }

  private boolean equalTo(Metadata another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(id, another.id)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(url, another.url);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code updatedAt}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(url);
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metadata{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", updatedAt=" + updatedAt
        + ", url=" + url
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2._Metadata {
    String createdAt;
    String id;
    String updatedAt;
    String url;
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("url")
    public void setUrl(@Nullable String url) {
      this.url = url;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Metadata fromJson(Json json) {
    Metadata.Builder builder = Metadata.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Metadata Metadata}.
   * @return A new Metadata builder
   */
  public static Metadata.Builder builder() {
    return new Metadata.Builder();
  }

  /**
   * Builds instances of type {@link Metadata Metadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String createdAt;
    private String id;
    private String updatedAt;
    private String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Metadata instance) {
      return from((_Metadata) instance);
    }

    /**
     * Copy abstract value type {@code _Metadata} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      String createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String updatedAtValue = instance.getUpdatedAt();
      if (updatedAtValue != null) {
        updatedAt(updatedAtValue);
      }
      String urlValue = instance.getUrl();
      if (urlValue != null) {
        url(urlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getUrl() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("url")
    public final Builder url(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Builds a new {@link Metadata Metadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Metadata build() {
      return new Metadata(this);
    }
  }
}
