package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _ApplicationEnvironmentResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ApplicationEnvironmentResponse.builder()}.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ApplicationEnvironmentResponse", generator = "Immutables")
public final class ApplicationEnvironmentResponse
    extends org.cloudfoundry.client.v2.applications._ApplicationEnvironmentResponse {
  private final @Nullable Map<String, Object> applicationEnvironmentJsons;
  private final @Nullable Map<String, Object> environmentJsons;
  private final @Nullable Map<String, Object> runningEnvironmentJsons;
  private final @Nullable Map<String, Object> stagingEnvironmentJsons;
  private final @Nullable Map<String, Object> systemEnvironmentJsons;

  private ApplicationEnvironmentResponse(ApplicationEnvironmentResponse.Builder builder) {
    this.applicationEnvironmentJsons = builder.applicationEnvironmentJsons == null ? null : createUnmodifiableMap(false, false, builder.applicationEnvironmentJsons);
    this.environmentJsons = builder.environmentJsons == null ? null : createUnmodifiableMap(false, false, builder.environmentJsons);
    this.runningEnvironmentJsons = builder.runningEnvironmentJsons == null ? null : createUnmodifiableMap(false, false, builder.runningEnvironmentJsons);
    this.stagingEnvironmentJsons = builder.stagingEnvironmentJsons == null ? null : createUnmodifiableMap(false, false, builder.stagingEnvironmentJsons);
    this.systemEnvironmentJsons = builder.systemEnvironmentJsons == null ? null : createUnmodifiableMap(false, false, builder.systemEnvironmentJsons);
  }

  /**
   * The application environment variables
   */
  @JsonProperty("application_env_json")
  @Override
  public @Nullable Map<String, Object> getApplicationEnvironmentJsons() {
    return applicationEnvironmentJsons;
  }

  /**
   * The environment variables
   */
  @JsonProperty("environment_json")
  @Override
  public @Nullable Map<String, Object> getEnvironmentJsons() {
    return environmentJsons;
  }

  /**
   * The running environment variables
   */
  @JsonProperty("running_env_json")
  @Override
  public @Nullable Map<String, Object> getRunningEnvironmentJsons() {
    return runningEnvironmentJsons;
  }

  /**
   * The staging environment variables
   */
  @JsonProperty("staging_env_json")
  @Override
  public @Nullable Map<String, Object> getStagingEnvironmentJsons() {
    return stagingEnvironmentJsons;
  }

  /**
   * The system environment variables
   */
  @JsonProperty("system_env_json")
  @Override
  public @Nullable Map<String, Object> getSystemEnvironmentJsons() {
    return systemEnvironmentJsons;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationEnvironmentResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationEnvironmentResponse
        && equalTo((ApplicationEnvironmentResponse) another);
  }

  private boolean equalTo(ApplicationEnvironmentResponse another) {
    return Objects.equals(applicationEnvironmentJsons, another.applicationEnvironmentJsons)
        && Objects.equals(environmentJsons, another.environmentJsons)
        && Objects.equals(runningEnvironmentJsons, another.runningEnvironmentJsons)
        && Objects.equals(stagingEnvironmentJsons, another.stagingEnvironmentJsons)
        && Objects.equals(systemEnvironmentJsons, another.systemEnvironmentJsons);
  }

  /**
   * Computes a hash code from attributes: {@code applicationEnvironmentJsons}, {@code environmentJsons}, {@code runningEnvironmentJsons}, {@code stagingEnvironmentJsons}, {@code systemEnvironmentJsons}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationEnvironmentJsons);
    h += (h << 5) + Objects.hashCode(environmentJsons);
    h += (h << 5) + Objects.hashCode(runningEnvironmentJsons);
    h += (h << 5) + Objects.hashCode(stagingEnvironmentJsons);
    h += (h << 5) + Objects.hashCode(systemEnvironmentJsons);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationEnvironmentResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationEnvironmentResponse{"
        + "applicationEnvironmentJsons=" + applicationEnvironmentJsons
        + ", environmentJsons=" + environmentJsons
        + ", runningEnvironmentJsons=" + runningEnvironmentJsons
        + ", stagingEnvironmentJsons=" + stagingEnvironmentJsons
        + ", systemEnvironmentJsons=" + systemEnvironmentJsons
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._ApplicationEnvironmentResponse {
    Map<String, Object> applicationEnvironmentJsons = null;
    Map<String, Object> environmentJsons = null;
    Map<String, Object> runningEnvironmentJsons = null;
    Map<String, Object> stagingEnvironmentJsons = null;
    Map<String, Object> systemEnvironmentJsons = null;
    @JsonProperty("application_env_json")
    public void setApplicationEnvironmentJsons(@Nullable Map<String, Object> applicationEnvironmentJsons) {
      this.applicationEnvironmentJsons = applicationEnvironmentJsons;
    }
    @JsonProperty("environment_json")
    public void setEnvironmentJsons(@Nullable Map<String, Object> environmentJsons) {
      this.environmentJsons = environmentJsons;
    }
    @JsonProperty("running_env_json")
    public void setRunningEnvironmentJsons(@Nullable Map<String, Object> runningEnvironmentJsons) {
      this.runningEnvironmentJsons = runningEnvironmentJsons;
    }
    @JsonProperty("staging_env_json")
    public void setStagingEnvironmentJsons(@Nullable Map<String, Object> stagingEnvironmentJsons) {
      this.stagingEnvironmentJsons = stagingEnvironmentJsons;
    }
    @JsonProperty("system_env_json")
    public void setSystemEnvironmentJsons(@Nullable Map<String, Object> systemEnvironmentJsons) {
      this.systemEnvironmentJsons = systemEnvironmentJsons;
    }
    @Override
    public Map<String, Object> getApplicationEnvironmentJsons() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getEnvironmentJsons() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getRunningEnvironmentJsons() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getStagingEnvironmentJsons() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getSystemEnvironmentJsons() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationEnvironmentResponse fromJson(Json json) {
    ApplicationEnvironmentResponse.Builder builder = ApplicationEnvironmentResponse.builder();
    if (json.applicationEnvironmentJsons != null) {
      builder.putAllApplicationEnvironmentJsons(json.applicationEnvironmentJsons);
    }
    if (json.environmentJsons != null) {
      builder.putAllEnvironmentJsons(json.environmentJsons);
    }
    if (json.runningEnvironmentJsons != null) {
      builder.putAllRunningEnvironmentJsons(json.runningEnvironmentJsons);
    }
    if (json.stagingEnvironmentJsons != null) {
      builder.putAllStagingEnvironmentJsons(json.stagingEnvironmentJsons);
    }
    if (json.systemEnvironmentJsons != null) {
      builder.putAllSystemEnvironmentJsons(json.systemEnvironmentJsons);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationEnvironmentResponse ApplicationEnvironmentResponse}.
   * @return A new ApplicationEnvironmentResponse builder
   */
  public static ApplicationEnvironmentResponse.Builder builder() {
    return new ApplicationEnvironmentResponse.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationEnvironmentResponse ApplicationEnvironmentResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Object> applicationEnvironmentJsons = null;
    private Map<String, Object> environmentJsons = null;
    private Map<String, Object> runningEnvironmentJsons = null;
    private Map<String, Object> stagingEnvironmentJsons = null;
    private Map<String, Object> systemEnvironmentJsons = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationEnvironmentResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationEnvironmentResponse instance) {
      return from((_ApplicationEnvironmentResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationEnvironmentResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationEnvironmentResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> applicationEnvironmentJsonsValue = instance.getApplicationEnvironmentJsons();
      if (applicationEnvironmentJsonsValue != null) {
        putAllApplicationEnvironmentJsons(applicationEnvironmentJsonsValue);
      }
      Map<String, Object> environmentJsonsValue = instance.getEnvironmentJsons();
      if (environmentJsonsValue != null) {
        putAllEnvironmentJsons(environmentJsonsValue);
      }
      Map<String, Object> runningEnvironmentJsonsValue = instance.getRunningEnvironmentJsons();
      if (runningEnvironmentJsonsValue != null) {
        putAllRunningEnvironmentJsons(runningEnvironmentJsonsValue);
      }
      Map<String, Object> stagingEnvironmentJsonsValue = instance.getStagingEnvironmentJsons();
      if (stagingEnvironmentJsonsValue != null) {
        putAllStagingEnvironmentJsons(stagingEnvironmentJsonsValue);
      }
      Map<String, Object> systemEnvironmentJsonsValue = instance.getSystemEnvironmentJsons();
      if (systemEnvironmentJsonsValue != null) {
        putAllSystemEnvironmentJsons(systemEnvironmentJsonsValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getApplicationEnvironmentJsons() applicationEnvironmentJsons} map.
     * @param key The key in the applicationEnvironmentJsons map
     * @param value The associated value in the applicationEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationEnvironmentJson(String key, Object value) {
      if (this.applicationEnvironmentJsons == null) {
        this.applicationEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      this.applicationEnvironmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getApplicationEnvironmentJsons() applicationEnvironmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationEnvironmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.applicationEnvironmentJsons == null) {
        this.applicationEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.applicationEnvironmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironmentResponse#getApplicationEnvironmentJsons() applicationEnvironmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the applicationEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("application_env_json")
    public final Builder applicationEnvironmentJsons(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.applicationEnvironmentJsons = null;
        return this;
      }
      this.applicationEnvironmentJsons = new LinkedHashMap<String, Object>();
      return putAllApplicationEnvironmentJsons(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironmentResponse#getApplicationEnvironmentJsons() applicationEnvironmentJsons} map. Nulls are not permitted
     * @param entries The entries that will be added to the applicationEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllApplicationEnvironmentJsons(Map<String, ? extends Object> entries) {
      if (this.applicationEnvironmentJsons == null) {
        this.applicationEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.applicationEnvironmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getEnvironmentJsons() environmentJsons} map.
     * @param key The key in the environmentJsons map
     * @param value The associated value in the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(String key, Object value) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      this.environmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironmentResponse#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("environment_json")
    public final Builder environmentJsons(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.environmentJsons = null;
        return this;
      }
      this.environmentJsons = new LinkedHashMap<String, Object>();
      return putAllEnvironmentJsons(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironmentResponse#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> entries) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.environmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getRunningEnvironmentJsons() runningEnvironmentJsons} map.
     * @param key The key in the runningEnvironmentJsons map
     * @param value The associated value in the runningEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningEnvironmentJson(String key, Object value) {
      if (this.runningEnvironmentJsons == null) {
        this.runningEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      this.runningEnvironmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getRunningEnvironmentJsons() runningEnvironmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningEnvironmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.runningEnvironmentJsons == null) {
        this.runningEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.runningEnvironmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironmentResponse#getRunningEnvironmentJsons() runningEnvironmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the runningEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("running_env_json")
    public final Builder runningEnvironmentJsons(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.runningEnvironmentJsons = null;
        return this;
      }
      this.runningEnvironmentJsons = new LinkedHashMap<String, Object>();
      return putAllRunningEnvironmentJsons(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironmentResponse#getRunningEnvironmentJsons() runningEnvironmentJsons} map. Nulls are not permitted
     * @param entries The entries that will be added to the runningEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRunningEnvironmentJsons(Map<String, ? extends Object> entries) {
      if (this.runningEnvironmentJsons == null) {
        this.runningEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.runningEnvironmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getStagingEnvironmentJsons() stagingEnvironmentJsons} map.
     * @param key The key in the stagingEnvironmentJsons map
     * @param value The associated value in the stagingEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingEnvironmentJson(String key, Object value) {
      if (this.stagingEnvironmentJsons == null) {
        this.stagingEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      this.stagingEnvironmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getStagingEnvironmentJsons() stagingEnvironmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingEnvironmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.stagingEnvironmentJsons == null) {
        this.stagingEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.stagingEnvironmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironmentResponse#getStagingEnvironmentJsons() stagingEnvironmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the stagingEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_env_json")
    public final Builder stagingEnvironmentJsons(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.stagingEnvironmentJsons = null;
        return this;
      }
      this.stagingEnvironmentJsons = new LinkedHashMap<String, Object>();
      return putAllStagingEnvironmentJsons(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironmentResponse#getStagingEnvironmentJsons() stagingEnvironmentJsons} map. Nulls are not permitted
     * @param entries The entries that will be added to the stagingEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllStagingEnvironmentJsons(Map<String, ? extends Object> entries) {
      if (this.stagingEnvironmentJsons == null) {
        this.stagingEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.stagingEnvironmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getSystemEnvironmentJsons() systemEnvironmentJsons} map.
     * @param key The key in the systemEnvironmentJsons map
     * @param value The associated value in the systemEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemEnvironmentJson(String key, Object value) {
      if (this.systemEnvironmentJsons == null) {
        this.systemEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      this.systemEnvironmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEnvironmentResponse#getSystemEnvironmentJsons() systemEnvironmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemEnvironmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.systemEnvironmentJsons == null) {
        this.systemEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.systemEnvironmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEnvironmentResponse#getSystemEnvironmentJsons() systemEnvironmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the systemEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("system_env_json")
    public final Builder systemEnvironmentJsons(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.systemEnvironmentJsons = null;
        return this;
      }
      this.systemEnvironmentJsons = new LinkedHashMap<String, Object>();
      return putAllSystemEnvironmentJsons(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEnvironmentResponse#getSystemEnvironmentJsons() systemEnvironmentJsons} map. Nulls are not permitted
     * @param entries The entries that will be added to the systemEnvironmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllSystemEnvironmentJsons(Map<String, ? extends Object> entries) {
      if (this.systemEnvironmentJsons == null) {
        this.systemEnvironmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.systemEnvironmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ApplicationEnvironmentResponse ApplicationEnvironmentResponse}.
     * @return An immutable instance of ApplicationEnvironmentResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationEnvironmentResponse build() {
      return new ApplicationEnvironmentResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
