package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Remove a Service Binding from an Application operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveApplicationServiceBindingRequest", generator = "Immutables")
public final class RemoveApplicationServiceBindingRequest
    extends org.cloudfoundry.client.v2.applications._RemoveApplicationServiceBindingRequest {
  private final String applicationId;
  private final String serviceBindingId;

  private RemoveApplicationServiceBindingRequest(RemoveApplicationServiceBindingRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.serviceBindingId = builder.serviceBindingId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The service binding id
   */
  @Override
  public String getServiceBindingId() {
    return serviceBindingId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveApplicationServiceBindingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveApplicationServiceBindingRequest
        && equalTo((RemoveApplicationServiceBindingRequest) another);
  }

  private boolean equalTo(RemoveApplicationServiceBindingRequest another) {
    return applicationId.equals(another.applicationId)
        && serviceBindingId.equals(another.serviceBindingId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code serviceBindingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + serviceBindingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveApplicationServiceBindingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveApplicationServiceBindingRequest{"
        + "applicationId=" + applicationId
        + ", serviceBindingId=" + serviceBindingId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveApplicationServiceBindingRequest RemoveApplicationServiceBindingRequest}.
   * @return A new RemoveApplicationServiceBindingRequest builder
   */
  public static RemoveApplicationServiceBindingRequest.Builder builder() {
    return new RemoveApplicationServiceBindingRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveApplicationServiceBindingRequest RemoveApplicationServiceBindingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_SERVICE_BINDING_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String serviceBindingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveApplicationServiceBindingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveApplicationServiceBindingRequest instance) {
      return from((_RemoveApplicationServiceBindingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveApplicationServiceBindingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveApplicationServiceBindingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      serviceBindingId(instance.getServiceBindingId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveApplicationServiceBindingRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveApplicationServiceBindingRequest#getServiceBindingId() serviceBindingId} attribute.
     * @param serviceBindingId The value for serviceBindingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String serviceBindingId) {
      this.serviceBindingId = Objects.requireNonNull(serviceBindingId, "serviceBindingId");
      initBits &= ~INIT_BIT_SERVICE_BINDING_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveApplicationServiceBindingRequest RemoveApplicationServiceBindingRequest}.
     * @return An immutable instance of RemoveApplicationServiceBindingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveApplicationServiceBindingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveApplicationServiceBindingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_SERVICE_BINDING_ID) != 0) attributes.add("serviceBindingId");
      return "Cannot build RemoveApplicationServiceBindingRequest, some of required attributes are not set " + attributes;
    }
  }
}
