package org.cloudfoundry.client.v2.applicationusageevents;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;

/**
 * Base class for resources that contain application usage events
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ApplicationUsageEventResource", generator = "Immutables")
public final class ApplicationUsageEventResource
    extends org.cloudfoundry.client.v2.applicationusageevents._ApplicationUsageEventResource {
  private final @Nullable ApplicationUsageEventEntity entity;
  private final @Nullable Metadata metadata;

  private ApplicationUsageEventResource(ApplicationUsageEventResource.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable ApplicationUsageEventEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationUsageEventResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationUsageEventResource
        && equalTo((ApplicationUsageEventResource) another);
  }

  private boolean equalTo(ApplicationUsageEventResource another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationUsageEventResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationUsageEventResource{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.applicationusageevents._ApplicationUsageEventResource {
    ApplicationUsageEventEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable ApplicationUsageEventEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public ApplicationUsageEventEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationUsageEventResource fromJson(Json json) {
    ApplicationUsageEventResource.Builder builder = ApplicationUsageEventResource.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationUsageEventResource ApplicationUsageEventResource}.
   * @return A new ApplicationUsageEventResource builder
   */
  public static ApplicationUsageEventResource.Builder builder() {
    return new ApplicationUsageEventResource.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationUsageEventResource ApplicationUsageEventResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private ApplicationUsageEventEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationUsageEventResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationUsageEventResource instance) {
      return from((_ApplicationUsageEventResource) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationUsageEventResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationUsageEventResource instance) {
      Objects.requireNonNull(instance, "instance");
      ApplicationUsageEventEntity entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationUsageEventResource#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable ApplicationUsageEventEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationUsageEventResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link ApplicationUsageEventResource ApplicationUsageEventResource}.
     * @return An immutable instance of ApplicationUsageEventResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationUsageEventResource build() {
      return new ApplicationUsageEventResource(this);
    }
  }
}
