package org.cloudfoundry.client.v2.applicationusageevents;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Application Usage Events operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetApplicationUsageEventRequest", generator = "Immutables")
public final class GetApplicationUsageEventRequest
    extends org.cloudfoundry.client.v2.applicationusageevents._GetApplicationUsageEventRequest {
  private final String applicationUsageEventId;

  private GetApplicationUsageEventRequest(GetApplicationUsageEventRequest.Builder builder) {
    this.applicationUsageEventId = builder.applicationUsageEventId;
  }

  /**
   * The service usage event id
   */
  @Override
  public String getApplicationUsageEventId() {
    return applicationUsageEventId;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationUsageEventRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationUsageEventRequest
        && equalTo((GetApplicationUsageEventRequest) another);
  }

  private boolean equalTo(GetApplicationUsageEventRequest another) {
    return applicationUsageEventId.equals(another.applicationUsageEventId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationUsageEventId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationUsageEventId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationUsageEventRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationUsageEventRequest{"
        + "applicationUsageEventId=" + applicationUsageEventId
        + "}";
  }

  /**
   * Creates a builder for {@link GetApplicationUsageEventRequest GetApplicationUsageEventRequest}.
   * @return A new GetApplicationUsageEventRequest builder
   */
  public static GetApplicationUsageEventRequest.Builder builder() {
    return new GetApplicationUsageEventRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationUsageEventRequest GetApplicationUsageEventRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_USAGE_EVENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationUsageEventId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationUsageEventRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationUsageEventRequest instance) {
      return from((_GetApplicationUsageEventRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationUsageEventRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationUsageEventRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationUsageEventId(instance.getApplicationUsageEventId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationUsageEventRequest#getApplicationUsageEventId() applicationUsageEventId} attribute.
     * @param applicationUsageEventId The value for applicationUsageEventId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationUsageEventId(String applicationUsageEventId) {
      this.applicationUsageEventId = Objects.requireNonNull(applicationUsageEventId, "applicationUsageEventId");
      initBits &= ~INIT_BIT_APPLICATION_USAGE_EVENT_ID;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationUsageEventRequest GetApplicationUsageEventRequest}.
     * @return An immutable instance of GetApplicationUsageEventRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationUsageEventRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationUsageEventRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_USAGE_EVENT_ID) != 0) attributes.add("applicationUsageEventId");
      return "Cannot build GetApplicationUsageEventRequest, some of required attributes are not set " + attributes;
    }
  }
}
