package org.cloudfoundry.client.v2.organizationquotadefinitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Delete an Organization Quota Definition operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DeleteOrganizationQuotaDefinitionRequest", generator = "Immutables")
public final class DeleteOrganizationQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.organizationquotadefinitions._DeleteOrganizationQuotaDefinitionRequest {
  private final @Nullable Boolean async;
  private final String organizationQuotaDefinitionId;

  private DeleteOrganizationQuotaDefinitionRequest(DeleteOrganizationQuotaDefinitionRequest.Builder builder) {
    this.async = builder.async;
    this.organizationQuotaDefinitionId = builder.organizationQuotaDefinitionId;
  }

  /**
   * The async flag
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The quota definition id
   */
  @Override
  public String getOrganizationQuotaDefinitionId() {
    return organizationQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteOrganizationQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteOrganizationQuotaDefinitionRequest
        && equalTo((DeleteOrganizationQuotaDefinitionRequest) another);
  }

  private boolean equalTo(DeleteOrganizationQuotaDefinitionRequest another) {
    return Objects.equals(async, another.async)
        && organizationQuotaDefinitionId.equals(another.organizationQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code organizationQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(async);
    h += (h << 5) + organizationQuotaDefinitionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteOrganizationQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteOrganizationQuotaDefinitionRequest{"
        + "async=" + async
        + ", organizationQuotaDefinitionId=" + organizationQuotaDefinitionId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteOrganizationQuotaDefinitionRequest DeleteOrganizationQuotaDefinitionRequest}.
   * @return A new DeleteOrganizationQuotaDefinitionRequest builder
   */
  public static DeleteOrganizationQuotaDefinitionRequest.Builder builder() {
    return new DeleteOrganizationQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteOrganizationQuotaDefinitionRequest DeleteOrganizationQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String organizationQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteOrganizationQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteOrganizationQuotaDefinitionRequest instance) {
      return from((_DeleteOrganizationQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteOrganizationQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteOrganizationQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      organizationQuotaDefinitionId(instance.getOrganizationQuotaDefinitionId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteOrganizationQuotaDefinitionRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteOrganizationQuotaDefinitionRequest#getOrganizationQuotaDefinitionId() organizationQuotaDefinitionId} attribute.
     * @param organizationQuotaDefinitionId The value for organizationQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationQuotaDefinitionId(String organizationQuotaDefinitionId) {
      this.organizationQuotaDefinitionId = Objects.requireNonNull(organizationQuotaDefinitionId, "organizationQuotaDefinitionId");
      initBits &= ~INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteOrganizationQuotaDefinitionRequest DeleteOrganizationQuotaDefinitionRequest}.
     * @return An immutable instance of DeleteOrganizationQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteOrganizationQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteOrganizationQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID) != 0) attributes.add("organizationQuotaDefinitionId");
      return "Cannot build DeleteOrganizationQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
