package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Auditor operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_AssociateOrganizationAuditorRequest", generator = "Immutables")
public final class AssociateOrganizationAuditorRequest
    extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationAuditorRequest {
  private final String auditorId;
  private final String organizationId;

  private AssociateOrganizationAuditorRequest(AssociateOrganizationAuditorRequest.Builder builder) {
    this.auditorId = builder.auditorId;
    this.organizationId = builder.organizationId;
  }

  /**
   * The auditor id
   */
  @Override
  public String getAuditorId() {
    return auditorId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateOrganizationAuditorRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateOrganizationAuditorRequest
        && equalTo((AssociateOrganizationAuditorRequest) another);
  }

  private boolean equalTo(AssociateOrganizationAuditorRequest another) {
    return auditorId.equals(another.auditorId)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code auditorId}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditorId.hashCode();
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateOrganizationAuditorRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateOrganizationAuditorRequest{"
        + "auditorId=" + auditorId
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateOrganizationAuditorRequest AssociateOrganizationAuditorRequest}.
   * @return A new AssociateOrganizationAuditorRequest builder
   */
  public static AssociateOrganizationAuditorRequest.Builder builder() {
    return new AssociateOrganizationAuditorRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateOrganizationAuditorRequest AssociateOrganizationAuditorRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_AUDITOR_ID = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String auditorId;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateOrganizationAuditorRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateOrganizationAuditorRequest instance) {
      return from((_AssociateOrganizationAuditorRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateOrganizationAuditorRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateOrganizationAuditorRequest instance) {
      Objects.requireNonNull(instance, "instance");
      auditorId(instance.getAuditorId());
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationAuditorRequest#getAuditorId() auditorId} attribute.
     * @param auditorId The value for auditorId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String auditorId) {
      this.auditorId = Objects.requireNonNull(auditorId, "auditorId");
      initBits &= ~INIT_BIT_AUDITOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationAuditorRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateOrganizationAuditorRequest AssociateOrganizationAuditorRequest}.
     * @return An immutable instance of AssociateOrganizationAuditorRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateOrganizationAuditorRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateOrganizationAuditorRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUDITOR_ID) != 0) attributes.add("auditorId");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build AssociateOrganizationAuditorRequest, some of required attributes are not set " + attributes;
    }
  }
}
