package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Private Domain with the Organization operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_AssociateOrganizationPrivateDomainRequest", generator = "Immutables")
public final class AssociateOrganizationPrivateDomainRequest
    extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationPrivateDomainRequest {
  private final String organizationId;
  private final String privateDomainId;

  private AssociateOrganizationPrivateDomainRequest(AssociateOrganizationPrivateDomainRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.privateDomainId = builder.privateDomainId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The private domain id
   */
  @Override
  public String getPrivateDomainId() {
    return privateDomainId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateOrganizationPrivateDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateOrganizationPrivateDomainRequest
        && equalTo((AssociateOrganizationPrivateDomainRequest) another);
  }

  private boolean equalTo(AssociateOrganizationPrivateDomainRequest another) {
    return organizationId.equals(another.organizationId)
        && privateDomainId.equals(another.privateDomainId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code privateDomainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + privateDomainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateOrganizationPrivateDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateOrganizationPrivateDomainRequest{"
        + "organizationId=" + organizationId
        + ", privateDomainId=" + privateDomainId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateOrganizationPrivateDomainRequest AssociateOrganizationPrivateDomainRequest}.
   * @return A new AssociateOrganizationPrivateDomainRequest builder
   */
  public static AssociateOrganizationPrivateDomainRequest.Builder builder() {
    return new AssociateOrganizationPrivateDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateOrganizationPrivateDomainRequest AssociateOrganizationPrivateDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_PRIVATE_DOMAIN_ID = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String privateDomainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateOrganizationPrivateDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateOrganizationPrivateDomainRequest instance) {
      return from((_AssociateOrganizationPrivateDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateOrganizationPrivateDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateOrganizationPrivateDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      privateDomainId(instance.getPrivateDomainId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationPrivateDomainRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationPrivateDomainRequest#getPrivateDomainId() privateDomainId} attribute.
     * @param privateDomainId The value for privateDomainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder privateDomainId(String privateDomainId) {
      this.privateDomainId = Objects.requireNonNull(privateDomainId, "privateDomainId");
      initBits &= ~INIT_BIT_PRIVATE_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateOrganizationPrivateDomainRequest AssociateOrganizationPrivateDomainRequest}.
     * @return An immutable instance of AssociateOrganizationPrivateDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateOrganizationPrivateDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateOrganizationPrivateDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_PRIVATE_DOMAIN_ID) != 0) attributes.add("privateDomainId");
      return "Cannot build AssociateOrganizationPrivateDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
