package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Delete a Particular Organization operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DeleteOrganizationRequest", generator = "Immutables")
public final class DeleteOrganizationRequest
    extends org.cloudfoundry.client.v2.organizations._DeleteOrganizationRequest {
  private final @Nullable Boolean async;
  private final String organizationId;
  private final @Nullable Boolean recursive;

  private DeleteOrganizationRequest(DeleteOrganizationRequest.Builder builder) {
    this.async = builder.async;
    this.organizationId = builder.organizationId;
    this.recursive = builder.recursive;
  }

  /**
   * Whether to delete asynchronously
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * Whether to delete recursively
   */
  @Override
  public @Nullable Boolean getRecursive() {
    return recursive;
  }

  /**
   * This instance is equal to all instances of {@code DeleteOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteOrganizationRequest
        && equalTo((DeleteOrganizationRequest) another);
  }

  private boolean equalTo(DeleteOrganizationRequest another) {
    return Objects.equals(async, another.async)
        && organizationId.equals(another.organizationId)
        && Objects.equals(recursive, another.recursive);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code organizationId}, {@code recursive}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(async);
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(recursive);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteOrganizationRequest{"
        + "async=" + async
        + ", organizationId=" + organizationId
        + ", recursive=" + recursive
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteOrganizationRequest DeleteOrganizationRequest}.
   * @return A new DeleteOrganizationRequest builder
   */
  public static DeleteOrganizationRequest.Builder builder() {
    return new DeleteOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteOrganizationRequest DeleteOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String organizationId;
    private Boolean recursive;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteOrganizationRequest instance) {
      return from((_DeleteOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      organizationId(instance.getOrganizationId());
      Boolean recursiveValue = instance.getRecursive();
      if (recursiveValue != null) {
        recursive(recursiveValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteOrganizationRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteOrganizationRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteOrganizationRequest#getRecursive() recursive} attribute.
     * @param recursive The value for recursive (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder recursive(@Nullable Boolean recursive) {
      this.recursive = recursive;
      return this;
    }

    /**
     * Builds a new {@link DeleteOrganizationRequest DeleteOrganizationRequest}.
     * @return An immutable instance of DeleteOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build DeleteOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
