package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Spaces for the Organization operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListOrganizationSpacesRequest", generator = "Immutables")
public final class ListOrganizationSpacesRequest
    extends org.cloudfoundry.client.v2.organizations._ListOrganizationSpacesRequest {
  private final @Nullable List<String> applicationIds;
  private final @Nullable List<String> developerIds;
  private final @Nullable List<String> names;
  private final String organizationId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListOrganizationSpacesRequest(ListOrganizationSpacesRequest.Builder builder) {
    this.applicationIds = builder.applicationIds == null ? null : createUnmodifiableList(true, builder.applicationIds);
    this.developerIds = builder.developerIds == null ? null : createUnmodifiableList(true, builder.developerIds);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationId = builder.organizationId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The application ids
   */
  @Override
  public @Nullable List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The developer ids
   */
  @Override
  public @Nullable List<String> getDeveloperIds() {
    return developerIds;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListOrganizationSpacesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListOrganizationSpacesRequest
        && equalTo((ListOrganizationSpacesRequest) another);
  }

  private boolean equalTo(ListOrganizationSpacesRequest another) {
    return Objects.equals(applicationIds, another.applicationIds)
        && Objects.equals(developerIds, another.developerIds)
        && Objects.equals(names, another.names)
        && organizationId.equals(another.organizationId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationIds}, {@code developerIds}, {@code names}, {@code organizationId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationIds);
    h += (h << 5) + Objects.hashCode(developerIds);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListOrganizationSpacesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListOrganizationSpacesRequest{"
        + "applicationIds=" + applicationIds
        + ", developerIds=" + developerIds
        + ", names=" + names
        + ", organizationId=" + organizationId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListOrganizationSpacesRequest ListOrganizationSpacesRequest}.
   * @return A new ListOrganizationSpacesRequest builder
   */
  public static ListOrganizationSpacesRequest.Builder builder() {
    return new ListOrganizationSpacesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListOrganizationSpacesRequest ListOrganizationSpacesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> applicationIds = null;
    private List<String> developerIds = null;
    private List<String> names = null;
    private String organizationId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListOrganizationSpacesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListOrganizationSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListOrganizationSpacesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListOrganizationSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.organizations._ListOrganizationSpacesRequest) {
        org.cloudfoundry.client.v2.organizations._ListOrganizationSpacesRequest instance = (org.cloudfoundry.client.v2.organizations._ListOrganizationSpacesRequest) object;
        List<String> developerIdsValue = instance.getDeveloperIds();
        if (developerIdsValue != null) {
          addAllDeveloperIds(developerIdsValue);
        }
        organizationId(instance.getOrganizationId());
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> applicationIdsValue = instance.getApplicationIds();
        if (applicationIdsValue != null) {
          addAllApplicationIds(applicationIdsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Adds one element to {@link ListOrganizationSpacesRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListOrganizationSpacesRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListOrganizationSpacesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.applicationIds = null;
        return this;
      }
      this.applicationIds = new ArrayList<String>();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListOrganizationSpacesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "applicationIds element");
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListOrganizationSpacesRequest#getDeveloperIds() developerIds} list.
     * @param element A developerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(String element) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListOrganizationSpacesRequest#getDeveloperIds() developerIds} list.
     * @param elements An array of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(String... elements) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListOrganizationSpacesRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.developerIds = null;
        return this;
      }
      this.developerIds = new ArrayList<String>();
      return addAllDeveloperIds(elements);
    }

    /**
     * Adds elements to {@link ListOrganizationSpacesRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDeveloperIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "developerIds element");
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListOrganizationSpacesRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListOrganizationSpacesRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListOrganizationSpacesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListOrganizationSpacesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpacesRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpacesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpacesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationSpacesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListOrganizationSpacesRequest ListOrganizationSpacesRequest}.
     * @return An immutable instance of ListOrganizationSpacesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListOrganizationSpacesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListOrganizationSpacesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build ListOrganizationSpacesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
