package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Disassociate Manager with the Organization by Username operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveOrganizationManagerByUsernameRequest", generator = "Immutables")
public final class RemoveOrganizationManagerByUsernameRequest
    extends org.cloudfoundry.client.v2.organizations._RemoveOrganizationManagerByUsernameRequest {
  private final String organizationId;
  private final @Nullable String origin;
  private final String username;

  private RemoveOrganizationManagerByUsernameRequest(RemoveOrganizationManagerByUsernameRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.origin = builder.origin;
    this.username = builder.username;
  }

  /**
   * The organization id
   */
  @JsonProperty("organizationId")
  @JsonIgnore
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The origin
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The username
   */
  @JsonProperty("username")
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code RemoveOrganizationManagerByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveOrganizationManagerByUsernameRequest
        && equalTo((RemoveOrganizationManagerByUsernameRequest) another);
  }

  private boolean equalTo(RemoveOrganizationManagerByUsernameRequest another) {
    return organizationId.equals(another.organizationId)
        && Objects.equals(origin, another.origin)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code origin}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveOrganizationManagerByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveOrganizationManagerByUsernameRequest{"
        + "organizationId=" + organizationId
        + ", origin=" + origin
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.organizations._RemoveOrganizationManagerByUsernameRequest {
    String organizationId;
    String origin;
    String username;
    @JsonProperty("organizationId")
    @JsonIgnore
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("username")
    public void setUsername(String username) {
      this.username = username;
    }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RemoveOrganizationManagerByUsernameRequest fromJson(Json json) {
    RemoveOrganizationManagerByUsernameRequest.Builder builder = RemoveOrganizationManagerByUsernameRequest.builder();
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RemoveOrganizationManagerByUsernameRequest RemoveOrganizationManagerByUsernameRequest}.
   * @return A new RemoveOrganizationManagerByUsernameRequest builder
   */
  public static RemoveOrganizationManagerByUsernameRequest.Builder builder() {
    return new RemoveOrganizationManagerByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveOrganizationManagerByUsernameRequest RemoveOrganizationManagerByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String origin;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveOrganizationManagerByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveOrganizationManagerByUsernameRequest instance) {
      return from((_RemoveOrganizationManagerByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveOrganizationManagerByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveOrganizationManagerByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveOrganizationManagerByUsernameRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveOrganizationManagerByUsernameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveOrganizationManagerByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link RemoveOrganizationManagerByUsernameRequest RemoveOrganizationManagerByUsernameRequest}.
     * @return An immutable instance of RemoveOrganizationManagerByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveOrganizationManagerByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveOrganizationManagerByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build RemoveOrganizationManagerByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
