package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the deprecated Create a Private Domain operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreatePrivateDomainRequest", generator = "Immutables")
public final class CreatePrivateDomainRequest
    extends org.cloudfoundry.client.v2.privatedomains._CreatePrivateDomainRequest {
  private final String name;
  private final String owningOrganizationId;

  private CreatePrivateDomainRequest(CreatePrivateDomainRequest.Builder builder) {
    this.name = builder.name;
    this.owningOrganizationId = builder.owningOrganizationId;
  }

  /**
   * The domain name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The owning organization id
   */
  @JsonProperty("owning_organization_guid")
  @Override
  public String getOwningOrganizationId() {
    return owningOrganizationId;
  }

  /**
   * This instance is equal to all instances of {@code CreatePrivateDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreatePrivateDomainRequest
        && equalTo((CreatePrivateDomainRequest) another);
  }

  private boolean equalTo(CreatePrivateDomainRequest another) {
    return name.equals(another.name)
        && owningOrganizationId.equals(another.owningOrganizationId);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code owningOrganizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + owningOrganizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreatePrivateDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreatePrivateDomainRequest{"
        + "name=" + name
        + ", owningOrganizationId=" + owningOrganizationId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.privatedomains._CreatePrivateDomainRequest {
    String name;
    String owningOrganizationId;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("owning_organization_guid")
    public void setOwningOrganizationId(String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOwningOrganizationId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreatePrivateDomainRequest fromJson(Json json) {
    CreatePrivateDomainRequest.Builder builder = CreatePrivateDomainRequest.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.owningOrganizationId != null) {
      builder.owningOrganizationId(json.owningOrganizationId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreatePrivateDomainRequest CreatePrivateDomainRequest}.
   * @return A new CreatePrivateDomainRequest builder
   */
  public static CreatePrivateDomainRequest.Builder builder() {
    return new CreatePrivateDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreatePrivateDomainRequest CreatePrivateDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_OWNING_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String owningOrganizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreatePrivateDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreatePrivateDomainRequest instance) {
      return from((_CreatePrivateDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreatePrivateDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreatePrivateDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      owningOrganizationId(instance.getOwningOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link CreatePrivateDomainRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreatePrivateDomainRequest#getOwningOrganizationId() owningOrganizationId} attribute.
     * @param owningOrganizationId The value for owningOrganizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationId(String owningOrganizationId) {
      this.owningOrganizationId = Objects.requireNonNull(owningOrganizationId, "owningOrganizationId");
      initBits &= ~INIT_BIT_OWNING_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link CreatePrivateDomainRequest CreatePrivateDomainRequest}.
     * @return An immutable instance of CreatePrivateDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreatePrivateDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreatePrivateDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_OWNING_ORGANIZATION_ID) != 0) attributes.add("owningOrganizationId");
      return "Cannot build CreatePrivateDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
