package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Creating a Route operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreateRouteRequest", generator = "Immutables")
public final class CreateRouteRequest extends org.cloudfoundry.client.v2.routes._CreateRouteRequest {
  private final String domainId;
  private final @Nullable Boolean generatePort;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;
  private final String spaceId;

  private CreateRouteRequest(CreateRouteRequest.Builder builder) {
    this.domainId = builder.domainId;
    this.generatePort = builder.generatePort;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
    this.spaceId = builder.spaceId;
  }

  /**
   * The domain id
   */
  @JsonProperty("domain_guid")
  @Override
  public String getDomainId() {
    return domainId;
  }

  /**
   * The generate port
   */
  @JsonIgnore
  @Override
  public @Nullable Boolean getGeneratePort() {
    return generatePort;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code CreateRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateRouteRequest
        && equalTo((CreateRouteRequest) another);
  }

  private boolean equalTo(CreateRouteRequest another) {
    return domainId.equals(another.domainId)
        && Objects.equals(generatePort, another.generatePort)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}, {@code generatePort}, {@code host}, {@code path}, {@code port}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainId.hashCode();
    h += (h << 5) + Objects.hashCode(generatePort);
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateRouteRequest{"
        + "domainId=" + domainId
        + ", generatePort=" + generatePort
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.routes._CreateRouteRequest {
    String domainId;
    Boolean generatePort;
    String host;
    String path;
    Integer port;
    String spaceId;
    @JsonProperty("domain_guid")
    public void setDomainId(String domainId) {
      this.domainId = domainId;
    }
    @JsonIgnore
    public void setGeneratePort(@Nullable Boolean generatePort) {
      this.generatePort = generatePort;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @Override
    public String getDomainId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getGeneratePort() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateRouteRequest fromJson(Json json) {
    CreateRouteRequest.Builder builder = CreateRouteRequest.builder();
    if (json.domainId != null) {
      builder.domainId(json.domainId);
    }
    if (json.generatePort != null) {
      builder.generatePort(json.generatePort);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateRouteRequest CreateRouteRequest}.
   * @return A new CreateRouteRequest builder
   */
  public static CreateRouteRequest.Builder builder() {
    return new CreateRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateRouteRequest CreateRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String domainId;
    private Boolean generatePort;
    private String host;
    private String path;
    private Integer port;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateRouteRequest instance) {
      return from((_CreateRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domainId(instance.getDomainId());
      Boolean generatePortValue = instance.getGeneratePort();
      if (generatePortValue != null) {
        generatePort(generatePortValue);
      }
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String domainId) {
      this.domainId = Objects.requireNonNull(domainId, "domainId");
      initBits &= ~INIT_BIT_DOMAIN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getGeneratePort() generatePort} attribute.
     * @param generatePort The value for generatePort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder generatePort(@Nullable Boolean generatePort) {
      this.generatePort = generatePort;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link CreateRouteRequest CreateRouteRequest}.
     * @return An immutable instance of CreateRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_ID) != 0) attributes.add("domainId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build CreateRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
