package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Volume Mount details
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_VolumeMounts", generator = "Immutables")
public final class VolumeMounts extends org.cloudfoundry.client.v2.servicebindings._VolumeMounts {
  private final String containerDir;
  private final @Nullable String deviceType;
  private final @Nullable String mode;

  private VolumeMounts(VolumeMounts.Builder builder) {
    this.containerDir = builder.containerDir;
    this.deviceType = builder.deviceType;
    this.mode = builder.mode;
  }

  /**
   * @return The value of the {@code containerDir} attribute
   */
  @JsonProperty("container_dir")
  @Override
  public String getContainerDir() {
    return containerDir;
  }

  /**
   * @return The value of the {@code deviceType} attribute
   */
  @JsonProperty("device_type")
  @Override
  public @Nullable String getDeviceType() {
    return deviceType;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @JsonProperty("mode")
  @Override
  public @Nullable String getMode() {
    return mode;
  }

  /**
   * This instance is equal to all instances of {@code VolumeMounts} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VolumeMounts
        && equalTo((VolumeMounts) another);
  }

  private boolean equalTo(VolumeMounts another) {
    return containerDir.equals(another.containerDir)
        && Objects.equals(deviceType, another.deviceType)
        && Objects.equals(mode, another.mode);
  }

  /**
   * Computes a hash code from attributes: {@code containerDir}, {@code deviceType}, {@code mode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + containerDir.hashCode();
    h += (h << 5) + Objects.hashCode(deviceType);
    h += (h << 5) + Objects.hashCode(mode);
    return h;
  }

  /**
   * Prints the immutable value {@code VolumeMounts} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VolumeMounts{"
        + "containerDir=" + containerDir
        + ", deviceType=" + deviceType
        + ", mode=" + mode
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.servicebindings._VolumeMounts {
    String containerDir;
    String deviceType;
    String mode;
    @JsonProperty("container_dir")
    public void setContainerDir(String containerDir) {
      this.containerDir = containerDir;
    }
    @JsonProperty("device_type")
    public void setDeviceType(@Nullable String deviceType) {
      this.deviceType = deviceType;
    }
    @JsonProperty("mode")
    public void setMode(@Nullable String mode) {
      this.mode = mode;
    }
    @Override
    public String getContainerDir() { throw new UnsupportedOperationException(); }
    @Override
    public String getDeviceType() { throw new UnsupportedOperationException(); }
    @Override
    public String getMode() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static VolumeMounts fromJson(Json json) {
    VolumeMounts.Builder builder = VolumeMounts.builder();
    if (json.containerDir != null) {
      builder.containerDir(json.containerDir);
    }
    if (json.deviceType != null) {
      builder.deviceType(json.deviceType);
    }
    if (json.mode != null) {
      builder.mode(json.mode);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link VolumeMounts VolumeMounts}.
   * @return A new VolumeMounts builder
   */
  public static VolumeMounts.Builder builder() {
    return new VolumeMounts.Builder();
  }

  /**
   * Builds instances of type {@link VolumeMounts VolumeMounts}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CONTAINER_DIR = 0x1L;
    private long initBits = 0x1L;

    private String containerDir;
    private String deviceType;
    private String mode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VolumeMounts} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VolumeMounts instance) {
      return from((_VolumeMounts) instance);
    }

    /**
     * Copy abstract value type {@code _VolumeMounts} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_VolumeMounts instance) {
      Objects.requireNonNull(instance, "instance");
      containerDir(instance.getContainerDir());
      String deviceTypeValue = instance.getDeviceType();
      if (deviceTypeValue != null) {
        deviceType(deviceTypeValue);
      }
      String modeValue = instance.getMode();
      if (modeValue != null) {
        mode(modeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link VolumeMounts#getContainerDir() containerDir} attribute.
     * @param containerDir The value for containerDir 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("container_dir")
    public final Builder containerDir(String containerDir) {
      this.containerDir = Objects.requireNonNull(containerDir, "containerDir");
      initBits &= ~INIT_BIT_CONTAINER_DIR;
      return this;
    }

    /**
     * Initializes the value for the {@link VolumeMounts#getDeviceType() deviceType} attribute.
     * @param deviceType The value for deviceType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("device_type")
    public final Builder deviceType(@Nullable String deviceType) {
      this.deviceType = deviceType;
      return this;
    }

    /**
     * Initializes the value for the {@link VolumeMounts#getMode() mode} attribute.
     * @param mode The value for mode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mode")
    public final Builder mode(@Nullable String mode) {
      this.mode = mode;
      return this;
    }

    /**
     * Builds a new {@link VolumeMounts VolumeMounts}.
     * @return An immutable instance of VolumeMounts
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public VolumeMounts build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new VolumeMounts(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTAINER_DIR) != 0) attributes.add("containerDir");
      return "Cannot build VolumeMounts, some of required attributes are not set " + attributes;
    }
  }
}
