package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The resource response payload for the Get Permissions Response
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetServiceInstancePermissionsResponse", generator = "Immutables")
public final class GetServiceInstancePermissionsResponse
    extends org.cloudfoundry.client.v2.serviceinstances._GetServiceInstancePermissionsResponse {
  private final @Nullable Boolean manage;
  private final @Nullable Boolean read;

  private GetServiceInstancePermissionsResponse(GetServiceInstancePermissionsResponse.Builder builder) {
    this.manage = builder.manage;
    this.read = builder.read;
  }

  /**
   * The manage flag
   */
  @JsonProperty("manage")
  @Override
  public @Nullable Boolean getManage() {
    return manage;
  }

  /**
   * The read flag
   */
  @JsonProperty("read")
  @Override
  public @Nullable Boolean getRead() {
    return read;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceInstancePermissionsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceInstancePermissionsResponse
        && equalTo((GetServiceInstancePermissionsResponse) another);
  }

  private boolean equalTo(GetServiceInstancePermissionsResponse another) {
    return Objects.equals(manage, another.manage)
        && Objects.equals(read, another.read);
  }

  /**
   * Computes a hash code from attributes: {@code manage}, {@code read}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(manage);
    h += (h << 5) + Objects.hashCode(read);
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceInstancePermissionsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceInstancePermissionsResponse{"
        + "manage=" + manage
        + ", read=" + read
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.serviceinstances._GetServiceInstancePermissionsResponse {
    Boolean manage;
    Boolean read;
    @JsonProperty("manage")
    public void setManage(@Nullable Boolean manage) {
      this.manage = manage;
    }
    @JsonProperty("read")
    public void setRead(@Nullable Boolean read) {
      this.read = read;
    }
    @Override
    public Boolean getManage() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRead() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetServiceInstancePermissionsResponse fromJson(Json json) {
    GetServiceInstancePermissionsResponse.Builder builder = GetServiceInstancePermissionsResponse.builder();
    if (json.manage != null) {
      builder.manage(json.manage);
    }
    if (json.read != null) {
      builder.read(json.read);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetServiceInstancePermissionsResponse GetServiceInstancePermissionsResponse}.
   * @return A new GetServiceInstancePermissionsResponse builder
   */
  public static GetServiceInstancePermissionsResponse.Builder builder() {
    return new GetServiceInstancePermissionsResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceInstancePermissionsResponse GetServiceInstancePermissionsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean manage;
    private Boolean read;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceInstancePermissionsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceInstancePermissionsResponse instance) {
      return from((_GetServiceInstancePermissionsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceInstancePermissionsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceInstancePermissionsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean manageValue = instance.getManage();
      if (manageValue != null) {
        manage(manageValue);
      }
      Boolean readValue = instance.getRead();
      if (readValue != null) {
        read(readValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceInstancePermissionsResponse#getManage() manage} attribute.
     * @param manage The value for manage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("manage")
    public final Builder manage(@Nullable Boolean manage) {
      this.manage = manage;
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceInstancePermissionsResponse#getRead() read} attribute.
     * @param read The value for read (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("read")
    public final Builder read(@Nullable Boolean read) {
      this.read = read;
      return this;
    }

    /**
     * Builds a new {@link GetServiceInstancePermissionsResponse GetServiceInstancePermissionsResponse}.
     * @return An immutable instance of GetServiceInstancePermissionsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceInstancePermissionsResponse build() {
      return new GetServiceInstancePermissionsResponse(this);
    }
  }
}
