package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Routes for the Service Instance operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListServiceInstanceRoutesRequest", generator = "Immutables")
public final class ListServiceInstanceRoutesRequest
    extends org.cloudfoundry.client.v2.serviceinstances._ListServiceInstanceRoutesRequest {
  private final @Nullable List<String> domainId;
  private final @Nullable List<String> host;
  private final @Nullable List<String> organizationId;
  private final @Nullable List<String> path;
  private final @Nullable List<String> port;
  private final String serviceInstanceId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListServiceInstanceRoutesRequest(ListServiceInstanceRoutesRequest.Builder builder) {
    this.domainId = builder.domainId == null ? null : createUnmodifiableList(true, builder.domainId);
    this.host = builder.host == null ? null : createUnmodifiableList(true, builder.host);
    this.organizationId = builder.organizationId == null ? null : createUnmodifiableList(true, builder.organizationId);
    this.path = builder.path == null ? null : createUnmodifiableList(true, builder.path);
    this.port = builder.port == null ? null : createUnmodifiableList(true, builder.port);
    this.serviceInstanceId = builder.serviceInstanceId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The domain id
   */
  @Override
  public @Nullable List<String> getDomainId() {
    return domainId;
  }

  /**
   * The host
   */
  @Override
  public @Nullable List<String> getHost() {
    return host;
  }

  /**
   * The organization id
   */
  @Override
  public @Nullable List<String> getOrganizationId() {
    return organizationId;
  }

  /**
   * The path
   */
  @Override
  public @Nullable List<String> getPath() {
    return path;
  }

  /**
   * The port
   */
  @Override
  public @Nullable List<String> getPort() {
    return port;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceInstanceRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceInstanceRoutesRequest
        && equalTo((ListServiceInstanceRoutesRequest) another);
  }

  private boolean equalTo(ListServiceInstanceRoutesRequest another) {
    return Objects.equals(domainId, another.domainId)
        && Objects.equals(host, another.host)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && serviceInstanceId.equals(another.serviceInstanceId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}, {@code host}, {@code organizationId}, {@code path}, {@code port}, {@code serviceInstanceId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(domainId);
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + serviceInstanceId.hashCode();
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceInstanceRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceInstanceRoutesRequest{"
        + "domainId=" + domainId
        + ", host=" + host
        + ", organizationId=" + organizationId
        + ", path=" + path
        + ", port=" + port
        + ", serviceInstanceId=" + serviceInstanceId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceInstanceRoutesRequest ListServiceInstanceRoutesRequest}.
   * @return A new ListServiceInstanceRoutesRequest builder
   */
  public static ListServiceInstanceRoutesRequest.Builder builder() {
    return new ListServiceInstanceRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceInstanceRoutesRequest ListServiceInstanceRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> domainId = null;
    private List<String> host = null;
    private List<String> organizationId = null;
    private List<String> path = null;
    private List<String> port = null;
    private String serviceInstanceId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceInstanceRoutesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceInstanceRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceInstanceRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServiceInstanceRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.serviceinstances._ListServiceInstanceRoutesRequest) {
        org.cloudfoundry.client.v2.serviceinstances._ListServiceInstanceRoutesRequest instance = (org.cloudfoundry.client.v2.serviceinstances._ListServiceInstanceRoutesRequest) object;
        List<String> organizationIdValue = instance.getOrganizationId();
        if (organizationIdValue != null) {
          addAllOrganizationId(organizationIdValue);
        }
        List<String> hostValue = instance.getHost();
        if (hostValue != null) {
          addAllHost(hostValue);
        }
        List<String> pathValue = instance.getPath();
        if (pathValue != null) {
          addAllPath(pathValue);
        }
        serviceInstanceId(instance.getServiceInstanceId());
        List<String> portValue = instance.getPort();
        if (portValue != null) {
          addAllPort(portValue);
        }
        List<String> domainIdValue = instance.getDomainId();
        if (domainIdValue != null) {
          addAllDomainId(domainIdValue);
        }
      }
    }

    /**
     * Adds one element to {@link ListServiceInstanceRoutesRequest#getDomainId() domainId} list.
     * @param element A domainId element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainId == null) {
        this.domainId = new ArrayList<String>();
      }
      this.domainId.add(Objects.requireNonNull(element, "domainId element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getDomainId() domainId} list.
     * @param elements An array of domainId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String... elements) {
      if (this.domainId == null) {
        this.domainId = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainId.add(Objects.requireNonNull(element, "domainId element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceInstanceRoutesRequest#getDomainId() domainId} list.
     * @param elements An iterable of domainId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainId = null;
        return this;
      }
      this.domainId = new ArrayList<String>();
      return addAllDomainId(elements);
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getDomainId() domainId} list.
     * @param elements An iterable of domainId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainId(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainId element");
      if (this.domainId == null) {
        this.domainId = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainId.add(Objects.requireNonNull(element, "domainId element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceInstanceRoutesRequest#getHost() host} list.
     * @param element A host element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String element) {
      if (this.host == null) {
        this.host = new ArrayList<String>();
      }
      this.host.add(Objects.requireNonNull(element, "host element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getHost() host} list.
     * @param elements An array of host elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String... elements) {
      if (this.host == null) {
        this.host = new ArrayList<String>();
      }
      for (String element : elements) {
        this.host.add(Objects.requireNonNull(element, "host element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceInstanceRoutesRequest#getHost() host} list.
     * @param elements An iterable of host elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.host = null;
        return this;
      }
      this.host = new ArrayList<String>();
      return addAllHost(elements);
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getHost() host} list.
     * @param elements An iterable of host elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllHost(Iterable<String> elements) {
      Objects.requireNonNull(elements, "host element");
      if (this.host == null) {
        this.host = new ArrayList<String>();
      }
      for (String element : elements) {
        this.host.add(Objects.requireNonNull(element, "host element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceInstanceRoutesRequest#getOrganizationId() organizationId} list.
     * @param element A organizationId element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationId == null) {
        this.organizationId = new ArrayList<String>();
      }
      this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getOrganizationId() organizationId} list.
     * @param elements An array of organizationId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String... elements) {
      if (this.organizationId == null) {
        this.organizationId = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceInstanceRoutesRequest#getOrganizationId() organizationId} list.
     * @param elements An iterable of organizationId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationId = null;
        return this;
      }
      this.organizationId = new ArrayList<String>();
      return addAllOrganizationId(elements);
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getOrganizationId() organizationId} list.
     * @param elements An iterable of organizationId elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationId(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationId element");
      if (this.organizationId == null) {
        this.organizationId = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceInstanceRoutesRequest#getPath() path} list.
     * @param element A path element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(String element) {
      if (this.path == null) {
        this.path = new ArrayList<String>();
      }
      this.path.add(Objects.requireNonNull(element, "path element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getPath() path} list.
     * @param elements An array of path elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(String... elements) {
      if (this.path == null) {
        this.path = new ArrayList<String>();
      }
      for (String element : elements) {
        this.path.add(Objects.requireNonNull(element, "path element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceInstanceRoutesRequest#getPath() path} list.
     * @param elements An iterable of path elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.path = null;
        return this;
      }
      this.path = new ArrayList<String>();
      return addAllPath(elements);
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getPath() path} list.
     * @param elements An iterable of path elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPath(Iterable<String> elements) {
      Objects.requireNonNull(elements, "path element");
      if (this.path == null) {
        this.path = new ArrayList<String>();
      }
      for (String element : elements) {
        this.path.add(Objects.requireNonNull(element, "path element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceInstanceRoutesRequest#getPort() port} list.
     * @param element A port element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(String element) {
      if (this.port == null) {
        this.port = new ArrayList<String>();
      }
      this.port.add(Objects.requireNonNull(element, "port element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getPort() port} list.
     * @param elements An array of port elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(String... elements) {
      if (this.port == null) {
        this.port = new ArrayList<String>();
      }
      for (String element : elements) {
        this.port.add(Objects.requireNonNull(element, "port element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceInstanceRoutesRequest#getPort() port} list.
     * @param elements An iterable of port elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.port = null;
        return this;
      }
      this.port = new ArrayList<String>();
      return addAllPort(elements);
    }

    /**
     * Adds elements to {@link ListServiceInstanceRoutesRequest#getPort() port} list.
     * @param elements An iterable of port elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPort(Iterable<String> elements) {
      Objects.requireNonNull(elements, "port element");
      if (this.port == null) {
        this.port = new ArrayList<String>();
      }
      for (String element : elements) {
        this.port.add(Objects.requireNonNull(element, "port element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceInstanceRoutesRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceInstanceRoutesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceInstanceRoutesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceInstanceRoutesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListServiceInstanceRoutesRequest ListServiceInstanceRoutesRequest}.
     * @return An immutable instance of ListServiceInstanceRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceInstanceRoutesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListServiceInstanceRoutesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build ListServiceInstanceRoutesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
