package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List Service Plans operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListServicePlansRequest", generator = "Immutables")
public final class ListServicePlansRequest
    extends org.cloudfoundry.client.v2.serviceplans._ListServicePlansRequest {
  private final @Nullable Boolean active;
  private final @Nullable List<String> serviceBrokerIds;
  private final @Nullable List<String> serviceIds;
  private final @Nullable List<String> serviceInstanceIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListServicePlansRequest(ListServicePlansRequest.Builder builder) {
    this.active = builder.active;
    this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : createUnmodifiableList(true, builder.serviceBrokerIds);
    this.serviceIds = builder.serviceIds == null ? null : createUnmodifiableList(true, builder.serviceIds);
    this.serviceInstanceIds = builder.serviceInstanceIds == null ? null : createUnmodifiableList(true, builder.serviceInstanceIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The active flag
   */
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The service broker ids
   */
  @Override
  public @Nullable List<String> getServiceBrokerIds() {
    return serviceBrokerIds;
  }

  /**
   * The service ids
   */
  @Override
  public @Nullable List<String> getServiceIds() {
    return serviceIds;
  }

  /**
   * The service instance ids
   */
  @Override
  public @Nullable List<String> getServiceInstanceIds() {
    return serviceInstanceIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListServicePlansRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServicePlansRequest
        && equalTo((ListServicePlansRequest) another);
  }

  private boolean equalTo(ListServicePlansRequest another) {
    return Objects.equals(active, another.active)
        && Objects.equals(serviceBrokerIds, another.serviceBrokerIds)
        && Objects.equals(serviceIds, another.serviceIds)
        && Objects.equals(serviceInstanceIds, another.serviceInstanceIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code serviceBrokerIds}, {@code serviceIds}, {@code serviceInstanceIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(serviceBrokerIds);
    h += (h << 5) + Objects.hashCode(serviceIds);
    h += (h << 5) + Objects.hashCode(serviceInstanceIds);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServicePlansRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServicePlansRequest{"
        + "active=" + active
        + ", serviceBrokerIds=" + serviceBrokerIds
        + ", serviceIds=" + serviceIds
        + ", serviceInstanceIds=" + serviceInstanceIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListServicePlansRequest ListServicePlansRequest}.
   * @return A new ListServicePlansRequest builder
   */
  public static ListServicePlansRequest.Builder builder() {
    return new ListServicePlansRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServicePlansRequest ListServicePlansRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean active;
    private List<String> serviceBrokerIds = null;
    private List<String> serviceIds = null;
    private List<String> serviceInstanceIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServicePlansRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServicePlansRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServicePlansRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServicePlansRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.serviceplans._ListServicePlansRequest) {
        org.cloudfoundry.client.v2.serviceplans._ListServicePlansRequest instance = (org.cloudfoundry.client.v2.serviceplans._ListServicePlansRequest) object;
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        List<String> serviceIdsValue = instance.getServiceIds();
        if (serviceIdsValue != null) {
          addAllServiceIds(serviceIdsValue);
        }
        List<String> serviceInstanceIdsValue = instance.getServiceInstanceIds();
        if (serviceInstanceIdsValue != null) {
          addAllServiceInstanceIds(serviceInstanceIdsValue);
        }
        List<String> serviceBrokerIdsValue = instance.getServiceBrokerIds();
        if (serviceBrokerIdsValue != null) {
          addAllServiceBrokerIds(serviceBrokerIdsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param element A serviceBrokerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String element) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An array of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(String... elements) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBrokerIds = null;
        return this;
      }
      this.serviceBrokerIds = new ArrayList<String>();
      return addAllServiceBrokerIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBrokerIds element");
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceIds() serviceIds} list.
     * @param element A serviceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(String element) {
      if (this.serviceIds == null) {
        this.serviceIds = new ArrayList<String>();
      }
      this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceIds() serviceIds} list.
     * @param elements An array of serviceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceIds(String... elements) {
      if (this.serviceIds == null) {
        this.serviceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceIds() serviceIds} list.
     * @param elements An iterable of serviceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceIds = null;
        return this;
      }
      this.serviceIds = new ArrayList<String>();
      return addAllServiceIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceIds() serviceIds} list.
     * @param elements An iterable of serviceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceIds element");
      if (this.serviceIds == null) {
        this.serviceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param element A serviceInstanceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String element) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An array of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(String... elements) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceInstanceIds = null;
        return this;
      }
      this.serviceInstanceIds = new ArrayList<String>();
      return addAllServiceInstanceIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlansRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceInstanceIds element");
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlansRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListServicePlansRequest ListServicePlansRequest}.
     * @return An immutable instance of ListServicePlansRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServicePlansRequest build() {
      return new ListServicePlansRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
