package org.cloudfoundry.client.v2.serviceplanvisibilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Service Plan Visibility operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetServicePlanVisibilityRequest", generator = "Immutables")
public final class GetServicePlanVisibilityRequest
    extends org.cloudfoundry.client.v2.serviceplanvisibilities._GetServicePlanVisibilityRequest {
  private final String servicePlanVisibilityId;

  private GetServicePlanVisibilityRequest(GetServicePlanVisibilityRequest.Builder builder) {
    this.servicePlanVisibilityId = builder.servicePlanVisibilityId;
  }

  /**
   * The service plan visibility id
   */
  @Override
  public String getServicePlanVisibilityId() {
    return servicePlanVisibilityId;
  }

  /**
   * This instance is equal to all instances of {@code GetServicePlanVisibilityRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServicePlanVisibilityRequest
        && equalTo((GetServicePlanVisibilityRequest) another);
  }

  private boolean equalTo(GetServicePlanVisibilityRequest another) {
    return servicePlanVisibilityId.equals(another.servicePlanVisibilityId);
  }

  /**
   * Computes a hash code from attributes: {@code servicePlanVisibilityId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + servicePlanVisibilityId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServicePlanVisibilityRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServicePlanVisibilityRequest{"
        + "servicePlanVisibilityId=" + servicePlanVisibilityId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServicePlanVisibilityRequest GetServicePlanVisibilityRequest}.
   * @return A new GetServicePlanVisibilityRequest builder
   */
  public static GetServicePlanVisibilityRequest.Builder builder() {
    return new GetServicePlanVisibilityRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServicePlanVisibilityRequest GetServicePlanVisibilityRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_PLAN_VISIBILITY_ID = 0x1L;
    private long initBits = 0x1L;

    private String servicePlanVisibilityId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServicePlanVisibilityRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServicePlanVisibilityRequest instance) {
      return from((_GetServicePlanVisibilityRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServicePlanVisibilityRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServicePlanVisibilityRequest instance) {
      Objects.requireNonNull(instance, "instance");
      servicePlanVisibilityId(instance.getServicePlanVisibilityId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetServicePlanVisibilityRequest#getServicePlanVisibilityId() servicePlanVisibilityId} attribute.
     * @param servicePlanVisibilityId The value for servicePlanVisibilityId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanVisibilityId(String servicePlanVisibilityId) {
      this.servicePlanVisibilityId = Objects.requireNonNull(servicePlanVisibilityId, "servicePlanVisibilityId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_VISIBILITY_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServicePlanVisibilityRequest GetServicePlanVisibilityRequest}.
     * @return An immutable instance of GetServicePlanVisibilityRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServicePlanVisibilityRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServicePlanVisibilityRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_PLAN_VISIBILITY_ID) != 0) attributes.add("servicePlanVisibilityId");
      return "Cannot build GetServicePlanVisibilityRequest, some of required attributes are not set " + attributes;
    }
  }
}
