package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for Service Plan Visibility
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ServicePlanVisibilityEntity", generator = "Immutables")
public final class ServicePlanVisibilityEntity
    extends org.cloudfoundry.client.v2.serviceplanvisibilities._ServicePlanVisibilityEntity {
  private final @Nullable String organizationId;
  private final @Nullable String organizationUrl;
  private final @Nullable String servicePlanId;
  private final @Nullable String servicePlanUrl;

  private ServicePlanVisibilityEntity(ServicePlanVisibilityEntity.Builder builder) {
    this.organizationId = builder.organizationId;
    this.organizationUrl = builder.organizationUrl;
    this.servicePlanId = builder.servicePlanId;
    this.servicePlanUrl = builder.servicePlanUrl;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The organization url
   */
  @JsonProperty("organization_url")
  @Override
  public @Nullable String getOrganizationUrl() {
    return organizationUrl;
  }

  /**
   * The service plan id
   */
  @JsonProperty("service_plan_guid")
  @Override
  public @Nullable String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * The service plan url
   */
  @JsonProperty("service_plan_url")
  @Override
  public @Nullable String getServicePlanUrl() {
    return servicePlanUrl;
  }

  /**
   * This instance is equal to all instances of {@code ServicePlanVisibilityEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServicePlanVisibilityEntity
        && equalTo((ServicePlanVisibilityEntity) another);
  }

  private boolean equalTo(ServicePlanVisibilityEntity another) {
    return Objects.equals(organizationId, another.organizationId)
        && Objects.equals(organizationUrl, another.organizationUrl)
        && Objects.equals(servicePlanId, another.servicePlanId)
        && Objects.equals(servicePlanUrl, another.servicePlanUrl);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code organizationUrl}, {@code servicePlanId}, {@code servicePlanUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + Objects.hashCode(organizationUrl);
    h += (h << 5) + Objects.hashCode(servicePlanId);
    h += (h << 5) + Objects.hashCode(servicePlanUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code ServicePlanVisibilityEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServicePlanVisibilityEntity{"
        + "organizationId=" + organizationId
        + ", organizationUrl=" + organizationUrl
        + ", servicePlanId=" + servicePlanId
        + ", servicePlanUrl=" + servicePlanUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.serviceplanvisibilities._ServicePlanVisibilityEntity {
    String organizationId;
    String organizationUrl;
    String servicePlanId;
    String servicePlanUrl;
    @JsonProperty("organization_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("organization_url")
    public void setOrganizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
    }
    @JsonProperty("service_plan_guid")
    public void setServicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
    }
    @JsonProperty("service_plan_url")
    public void setServicePlanUrl(@Nullable String servicePlanUrl) {
      this.servicePlanUrl = servicePlanUrl;
    }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServicePlanVisibilityEntity fromJson(Json json) {
    ServicePlanVisibilityEntity.Builder builder = ServicePlanVisibilityEntity.builder();
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.organizationUrl != null) {
      builder.organizationUrl(json.organizationUrl);
    }
    if (json.servicePlanId != null) {
      builder.servicePlanId(json.servicePlanId);
    }
    if (json.servicePlanUrl != null) {
      builder.servicePlanUrl(json.servicePlanUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServicePlanVisibilityEntity ServicePlanVisibilityEntity}.
   * @return A new ServicePlanVisibilityEntity builder
   */
  public static ServicePlanVisibilityEntity.Builder builder() {
    return new ServicePlanVisibilityEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServicePlanVisibilityEntity ServicePlanVisibilityEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String organizationId;
    private String organizationUrl;
    private String servicePlanId;
    private String servicePlanUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServicePlanVisibilityEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServicePlanVisibilityEntity instance) {
      return from((_ServicePlanVisibilityEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServicePlanVisibilityEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServicePlanVisibilityEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      String organizationUrlValue = instance.getOrganizationUrl();
      if (organizationUrlValue != null) {
        organizationUrl(organizationUrlValue);
      }
      String servicePlanIdValue = instance.getServicePlanId();
      if (servicePlanIdValue != null) {
        servicePlanId(servicePlanIdValue);
      }
      String servicePlanUrlValue = instance.getServicePlanUrl();
      if (servicePlanUrlValue != null) {
        servicePlanUrl(servicePlanUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanVisibilityEntity#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_guid")
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanVisibilityEntity#getOrganizationUrl() organizationUrl} attribute.
     * @param organizationUrl The value for organizationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_url")
    public final Builder organizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanVisibilityEntity#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_guid")
    public final Builder servicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanVisibilityEntity#getServicePlanUrl() servicePlanUrl} attribute.
     * @param servicePlanUrl The value for servicePlanUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_url")
    public final Builder servicePlanUrl(@Nullable String servicePlanUrl) {
      this.servicePlanUrl = servicePlanUrl;
      return this;
    }

    /**
     * Builds a new {@link ServicePlanVisibilityEntity ServicePlanVisibilityEntity}.
     * @return An immutable instance of ServicePlanVisibilityEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServicePlanVisibilityEntity build() {
      return new ServicePlanVisibilityEntity(this);
    }
  }
}
