package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for Services
 */
@SuppressWarnings({"all", "deprecation"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ServiceEntity", generator = "Immutables")
public final class ServiceEntity extends org.cloudfoundry.client.v2.services._ServiceEntity {
  private final @Nullable Boolean active;
  private final @Nullable Boolean bindable;
  private final @Nullable String description;
  private final @Nullable String documentationUrl;
  private final @Nullable String extra;
  private final @Nullable String infoUrl;
  private final @Nullable String label;
  private final @Nullable String longDescription;
  private final @Nullable Boolean planUpdateable;
  private final @Nullable String provider;
  private final @Nullable List<String> requires;
  private final @Nullable String serviceBrokerId;
  private final @Nullable String servicePlansUrl;
  private final @Nullable List<String> tags;
  private final @Nullable String uniqueId;
  private final @Nullable String url;
  private final @Nullable String version;

  private ServiceEntity(ServiceEntity.Builder builder) {
    this.active = builder.active;
    this.bindable = builder.bindable;
    this.description = builder.description;
    this.documentationUrl = builder.documentationUrl;
    this.extra = builder.extra;
    this.infoUrl = builder.infoUrl;
    this.label = builder.label;
    this.longDescription = builder.longDescription;
    this.planUpdateable = builder.planUpdateable;
    this.provider = builder.provider;
    this.requires = builder.requires == null ? null : createUnmodifiableList(true, builder.requires);
    this.serviceBrokerId = builder.serviceBrokerId;
    this.servicePlansUrl = builder.servicePlansUrl;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.uniqueId = builder.uniqueId;
    this.url = builder.url;
    this.version = builder.version;
  }

  /**
   * The active status
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The bindable status
   */
  @JsonProperty("bindable")
  @Override
  public @Nullable Boolean getBindable() {
    return bindable;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The documentation url
   */
  @JsonProperty("documentation_url")
  @Deprecated
  @Override
  public @Nullable String getDocumentationUrl() {
    return documentationUrl;
  }

  /**
   * Extra service-related data
   */
  @JsonProperty("extra")
  @Override
  public @Nullable String getExtra() {
    return extra;
  }

  /**
   * The info url
   */
  @JsonProperty("info_url")
  @Deprecated
  @Override
  public @Nullable String getInfoUrl() {
    return infoUrl;
  }

  /**
   * The name of the service
   */
  @JsonProperty("label")
  @Override
  public @Nullable String getLabel() {
    return label;
  }

  /**
   * The long description
   */
  @JsonProperty("long_description")
  @Deprecated
  @Override
  public @Nullable String getLongDescription() {
    return longDescription;
  }

  /**
   * Whether the service can be updated to a different plan
   */
  @JsonProperty("plan_updateable")
  @Override
  public @Nullable Boolean getPlanUpdateable() {
    return planUpdateable;
  }

  /**
   * The name of the service provider
   */
  @JsonProperty("provider")
  @Deprecated
  @Override
  public @Nullable String getProvider() {
    return provider;
  }

  /**
   * Required dependencies
   */
  @JsonProperty("requires")
  @Override
  public @Nullable List<String> getRequires() {
    return requires;
  }

  /**
   * The service broker id
   */
  @JsonProperty("service_broker_guid")
  @Override
  public @Nullable String getServiceBrokerId() {
    return serviceBrokerId;
  }

  /**
   * The service plans url
   */
  @JsonProperty("service_plans_url")
  @Override
  public @Nullable String getServicePlansUrl() {
    return servicePlansUrl;
  }

  /**
   * The tags
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * The unique id to identify the service with the broker
   */
  @JsonProperty("unique_id")
  @Override
  public @Nullable String getUniqueId() {
    return uniqueId;
  }

  /**
   * The url
   */
  @JsonProperty("url")
  @Deprecated
  @Override
  public @Nullable String getUrl() {
    return url;
  }

  /**
   * The version
   */
  @JsonProperty("version")
  @Deprecated
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code ServiceEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceEntity
        && equalTo((ServiceEntity) another);
  }

  private boolean equalTo(ServiceEntity another) {
    return Objects.equals(active, another.active)
        && Objects.equals(bindable, another.bindable)
        && Objects.equals(description, another.description)
        && Objects.equals(documentationUrl, another.documentationUrl)
        && Objects.equals(extra, another.extra)
        && Objects.equals(infoUrl, another.infoUrl)
        && Objects.equals(label, another.label)
        && Objects.equals(longDescription, another.longDescription)
        && Objects.equals(planUpdateable, another.planUpdateable)
        && Objects.equals(provider, another.provider)
        && Objects.equals(requires, another.requires)
        && Objects.equals(serviceBrokerId, another.serviceBrokerId)
        && Objects.equals(servicePlansUrl, another.servicePlansUrl)
        && Objects.equals(tags, another.tags)
        && Objects.equals(uniqueId, another.uniqueId)
        && Objects.equals(url, another.url)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code bindable}, {@code description}, {@code documentationUrl}, {@code extra}, {@code infoUrl}, {@code label}, {@code longDescription}, {@code planUpdateable}, {@code provider}, {@code requires}, {@code serviceBrokerId}, {@code servicePlansUrl}, {@code tags}, {@code uniqueId}, {@code url}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(bindable);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(documentationUrl);
    h += (h << 5) + Objects.hashCode(extra);
    h += (h << 5) + Objects.hashCode(infoUrl);
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(longDescription);
    h += (h << 5) + Objects.hashCode(planUpdateable);
    h += (h << 5) + Objects.hashCode(provider);
    h += (h << 5) + Objects.hashCode(requires);
    h += (h << 5) + Objects.hashCode(serviceBrokerId);
    h += (h << 5) + Objects.hashCode(servicePlansUrl);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + Objects.hashCode(uniqueId);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceEntity{"
        + "active=" + active
        + ", bindable=" + bindable
        + ", description=" + description
        + ", documentationUrl=" + documentationUrl
        + ", extra=" + extra
        + ", infoUrl=" + infoUrl
        + ", label=" + label
        + ", longDescription=" + longDescription
        + ", planUpdateable=" + planUpdateable
        + ", provider=" + provider
        + ", requires=" + requires
        + ", serviceBrokerId=" + serviceBrokerId
        + ", servicePlansUrl=" + servicePlansUrl
        + ", tags=" + tags
        + ", uniqueId=" + uniqueId
        + ", url=" + url
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.services._ServiceEntity {
    Boolean active;
    Boolean bindable;
    String description;
    String documentationUrl;
    String extra;
    String infoUrl;
    String label;
    String longDescription;
    Boolean planUpdateable;
    String provider;
    List<String> requires = null;
    String serviceBrokerId;
    String servicePlansUrl;
    List<String> tags = null;
    String uniqueId;
    String url;
    String version;
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("bindable")
    public void setBindable(@Nullable Boolean bindable) {
      this.bindable = bindable;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("documentation_url")
    public void setDocumentationUrl(@Nullable String documentationUrl) {
      this.documentationUrl = documentationUrl;
    }
    @JsonProperty("extra")
    public void setExtra(@Nullable String extra) {
      this.extra = extra;
    }
    @JsonProperty("info_url")
    public void setInfoUrl(@Nullable String infoUrl) {
      this.infoUrl = infoUrl;
    }
    @JsonProperty("label")
    public void setLabel(@Nullable String label) {
      this.label = label;
    }
    @JsonProperty("long_description")
    public void setLongDescription(@Nullable String longDescription) {
      this.longDescription = longDescription;
    }
    @JsonProperty("plan_updateable")
    public void setPlanUpdateable(@Nullable Boolean planUpdateable) {
      this.planUpdateable = planUpdateable;
    }
    @JsonProperty("provider")
    public void setProvider(@Nullable String provider) {
      this.provider = provider;
    }
    @JsonProperty("requires")
    public void setRequires(@Nullable List<String> requires) {
      this.requires = requires;
    }
    @JsonProperty("service_broker_guid")
    public void setServiceBrokerId(@Nullable String serviceBrokerId) {
      this.serviceBrokerId = serviceBrokerId;
    }
    @JsonProperty("service_plans_url")
    public void setServicePlansUrl(@Nullable String servicePlansUrl) {
      this.servicePlansUrl = servicePlansUrl;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("unique_id")
    public void setUniqueId(@Nullable String uniqueId) {
      this.uniqueId = uniqueId;
    }
    @JsonProperty("url")
    public void setUrl(@Nullable String url) {
      this.url = url;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getBindable() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDocumentationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getExtra() { throw new UnsupportedOperationException(); }
    @Override
    public String getInfoUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getLongDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPlanUpdateable() { throw new UnsupportedOperationException(); }
    @Override
    public String getProvider() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRequires() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBrokerId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlansUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public String getUniqueId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceEntity fromJson(Json json) {
    ServiceEntity.Builder builder = ServiceEntity.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.bindable != null) {
      builder.bindable(json.bindable);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.documentationUrl != null) {
      builder.documentationUrl(json.documentationUrl);
    }
    if (json.extra != null) {
      builder.extra(json.extra);
    }
    if (json.infoUrl != null) {
      builder.infoUrl(json.infoUrl);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.longDescription != null) {
      builder.longDescription(json.longDescription);
    }
    if (json.planUpdateable != null) {
      builder.planUpdateable(json.planUpdateable);
    }
    if (json.provider != null) {
      builder.provider(json.provider);
    }
    if (json.requires != null) {
      builder.addAllRequires(json.requires);
    }
    if (json.serviceBrokerId != null) {
      builder.serviceBrokerId(json.serviceBrokerId);
    }
    if (json.servicePlansUrl != null) {
      builder.servicePlansUrl(json.servicePlansUrl);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.uniqueId != null) {
      builder.uniqueId(json.uniqueId);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceEntity ServiceEntity}.
   * @return A new ServiceEntity builder
   */
  public static ServiceEntity.Builder builder() {
    return new ServiceEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServiceEntity ServiceEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean active;
    private Boolean bindable;
    private String description;
    private String documentationUrl;
    private String extra;
    private String infoUrl;
    private String label;
    private String longDescription;
    private Boolean planUpdateable;
    private String provider;
    private List<String> requires = null;
    private String serviceBrokerId;
    private String servicePlansUrl;
    private List<String> tags = null;
    private String uniqueId;
    private String url;
    private String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceEntity instance) {
      return from((_ServiceEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean activeValue = instance.getActive();
      if (activeValue != null) {
        active(activeValue);
      }
      Boolean bindableValue = instance.getBindable();
      if (bindableValue != null) {
        bindable(bindableValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String documentationUrlValue = instance.getDocumentationUrl();
      if (documentationUrlValue != null) {
        documentationUrl(documentationUrlValue);
      }
      String extraValue = instance.getExtra();
      if (extraValue != null) {
        extra(extraValue);
      }
      String infoUrlValue = instance.getInfoUrl();
      if (infoUrlValue != null) {
        infoUrl(infoUrlValue);
      }
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        label(labelValue);
      }
      String longDescriptionValue = instance.getLongDescription();
      if (longDescriptionValue != null) {
        longDescription(longDescriptionValue);
      }
      Boolean planUpdateableValue = instance.getPlanUpdateable();
      if (planUpdateableValue != null) {
        planUpdateable(planUpdateableValue);
      }
      String providerValue = instance.getProvider();
      if (providerValue != null) {
        provider(providerValue);
      }
      List<String> requiresValue = instance.getRequires();
      if (requiresValue != null) {
        addAllRequires(requiresValue);
      }
      String serviceBrokerIdValue = instance.getServiceBrokerId();
      if (serviceBrokerIdValue != null) {
        serviceBrokerId(serviceBrokerIdValue);
      }
      String servicePlansUrlValue = instance.getServicePlansUrl();
      if (servicePlansUrlValue != null) {
        servicePlansUrl(servicePlansUrlValue);
      }
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      String uniqueIdValue = instance.getUniqueId();
      if (uniqueIdValue != null) {
        uniqueId(uniqueIdValue);
      }
      String urlValue = instance.getUrl();
      if (urlValue != null) {
        url(urlValue);
      }
      String versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getBindable() bindable} attribute.
     * @param bindable The value for bindable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bindable")
    public final Builder bindable(@Nullable Boolean bindable) {
      this.bindable = bindable;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getDocumentationUrl() documentationUrl} attribute.
     * @param documentationUrl The value for documentationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("documentation_url")
    @Deprecated
    public final Builder documentationUrl(@Nullable String documentationUrl) {
      this.documentationUrl = documentationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getExtra() extra} attribute.
     * @param extra The value for extra (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("extra")
    public final Builder extra(@Nullable String extra) {
      this.extra = extra;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getInfoUrl() infoUrl} attribute.
     * @param infoUrl The value for infoUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("info_url")
    @Deprecated
    public final Builder infoUrl(@Nullable String infoUrl) {
      this.infoUrl = infoUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getLabel() label} attribute.
     * @param label The value for label (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(@Nullable String label) {
      this.label = label;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getLongDescription() longDescription} attribute.
     * @param longDescription The value for longDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("long_description")
    @Deprecated
    public final Builder longDescription(@Nullable String longDescription) {
      this.longDescription = longDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getPlanUpdateable() planUpdateable} attribute.
     * @param planUpdateable The value for planUpdateable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("plan_updateable")
    public final Builder planUpdateable(@Nullable Boolean planUpdateable) {
      this.planUpdateable = planUpdateable;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getProvider() provider} attribute.
     * @param provider The value for provider (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("provider")
    @Deprecated
    public final Builder provider(@Nullable String provider) {
      this.provider = provider;
      return this;
    }

    /**
     * Adds one element to {@link ServiceEntity#getRequires() requires} list.
     * @param element A requires element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder require(String element) {
      if (this.requires == null) {
        this.requires = new ArrayList<String>();
      }
      this.requires.add(Objects.requireNonNull(element, "requires element"));
      return this;
    }

    /**
     * Adds elements to {@link ServiceEntity#getRequires() requires} list.
     * @param elements An array of requires elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requires(String... elements) {
      if (this.requires == null) {
        this.requires = new ArrayList<String>();
      }
      for (String element : elements) {
        this.requires.add(Objects.requireNonNull(element, "requires element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceEntity#getRequires() requires} list.
     * @param elements An iterable of requires elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requires")
    public final Builder requires(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.requires = null;
        return this;
      }
      this.requires = new ArrayList<String>();
      return addAllRequires(elements);
    }

    /**
     * Adds elements to {@link ServiceEntity#getRequires() requires} list.
     * @param elements An iterable of requires elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRequires(Iterable<String> elements) {
      Objects.requireNonNull(elements, "requires element");
      if (this.requires == null) {
        this.requires = new ArrayList<String>();
      }
      for (String element : elements) {
        this.requires.add(Objects.requireNonNull(element, "requires element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getServiceBrokerId() serviceBrokerId} attribute.
     * @param serviceBrokerId The value for serviceBrokerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_broker_guid")
    public final Builder serviceBrokerId(@Nullable String serviceBrokerId) {
      this.serviceBrokerId = serviceBrokerId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getServicePlansUrl() servicePlansUrl} attribute.
     * @param servicePlansUrl The value for servicePlansUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plans_url")
    public final Builder servicePlansUrl(@Nullable String servicePlansUrl) {
      this.servicePlansUrl = servicePlansUrl;
      return this;
    }

    /**
     * Adds one element to {@link ServiceEntity#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link ServiceEntity#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceEntity#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link ServiceEntity#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getUniqueId() uniqueId} attribute.
     * @param uniqueId The value for uniqueId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("unique_id")
    public final Builder uniqueId(@Nullable String uniqueId) {
      this.uniqueId = uniqueId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getUrl() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("url")
    @Deprecated
    public final Builder url(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceEntity#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    @Deprecated
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link ServiceEntity ServiceEntity}.
     * @return An immutable instance of ServiceEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceEntity build() {
      return new ServiceEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
