package org.cloudfoundry.client.v2.shareddomains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for the Domain resource
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_SharedDomainEntity", generator = "Immutables")
public final class SharedDomainEntity extends org.cloudfoundry.client.v2.shareddomains._SharedDomainEntity {
  private final @Nullable String name;
  private final @Nullable String routerGroupId;
  private final @Nullable String routerGroupType;

  private SharedDomainEntity(SharedDomainEntity.Builder builder) {
    this.name = builder.name;
    this.routerGroupId = builder.routerGroupId;
    this.routerGroupType = builder.routerGroupType;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The router group id
   */
  @JsonProperty("router_group_guid")
  @Override
  public @Nullable String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * The router group type
   */
  @JsonProperty("router_group_type")
  @Override
  public @Nullable String getRouterGroupType() {
    return routerGroupType;
  }

  /**
   * This instance is equal to all instances of {@code SharedDomainEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SharedDomainEntity
        && equalTo((SharedDomainEntity) another);
  }

  private boolean equalTo(SharedDomainEntity another) {
    return Objects.equals(name, another.name)
        && Objects.equals(routerGroupId, another.routerGroupId)
        && Objects.equals(routerGroupType, another.routerGroupType);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code routerGroupId}, {@code routerGroupType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(routerGroupId);
    h += (h << 5) + Objects.hashCode(routerGroupType);
    return h;
  }

  /**
   * Prints the immutable value {@code SharedDomainEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SharedDomainEntity{"
        + "name=" + name
        + ", routerGroupId=" + routerGroupId
        + ", routerGroupType=" + routerGroupType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.shareddomains._SharedDomainEntity {
    String name;
    String routerGroupId;
    String routerGroupType;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("router_group_type")
    public void setRouterGroupType(@Nullable String routerGroupType) {
      this.routerGroupType = routerGroupType;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SharedDomainEntity fromJson(Json json) {
    SharedDomainEntity.Builder builder = SharedDomainEntity.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.routerGroupType != null) {
      builder.routerGroupType(json.routerGroupType);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SharedDomainEntity SharedDomainEntity}.
   * @return A new SharedDomainEntity builder
   */
  public static SharedDomainEntity.Builder builder() {
    return new SharedDomainEntity.Builder();
  }

  /**
   * Builds instances of type {@link SharedDomainEntity SharedDomainEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String name;
    private String routerGroupId;
    private String routerGroupType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SharedDomainEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SharedDomainEntity instance) {
      return from((_SharedDomainEntity) instance);
    }

    /**
     * Copy abstract value type {@code _SharedDomainEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SharedDomainEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String routerGroupIdValue = instance.getRouterGroupId();
      if (routerGroupIdValue != null) {
        routerGroupId(routerGroupIdValue);
      }
      String routerGroupTypeValue = instance.getRouterGroupType();
      if (routerGroupTypeValue != null) {
        routerGroupType(routerGroupTypeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SharedDomainEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link SharedDomainEntity#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_guid")
    public final Builder routerGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
      return this;
    }

    /**
     * Initializes the value for the {@link SharedDomainEntity#getRouterGroupType() routerGroupType} attribute.
     * @param routerGroupType The value for routerGroupType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_type")
    public final Builder routerGroupType(@Nullable String routerGroupType) {
      this.routerGroupType = routerGroupType;
      return this;
    }

    /**
     * Builds a new {@link SharedDomainEntity SharedDomainEntity}.
     * @return An immutable instance of SharedDomainEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SharedDomainEntity build() {
      return new SharedDomainEntity(this);
    }
  }
}
