package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Update a Space Quota Definition operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UpdateSpaceQuotaDefinitionRequest", generator = "Immutables")
public final class UpdateSpaceQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.spacequotadefinitions._UpdateSpaceQuotaDefinitionRequest {
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer applicationTaskLimit;
  private final @Nullable Integer instanceMemoryLimit;
  private final @Nullable Integer memoryLimit;
  private final @Nullable String name;
  private final @Nullable Boolean nonBasicServicesAllowed;
  private final @Nullable String organizationId;
  private final String spaceQuotaDefinitionId;
  private final @Nullable Integer totalReservedRoutePorts;
  private final @Nullable Integer totalRoutes;
  private final @Nullable Integer totalServiceKeys;
  private final @Nullable Integer totalServices;

  private UpdateSpaceQuotaDefinitionRequest(UpdateSpaceQuotaDefinitionRequest.Builder builder) {
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.applicationTaskLimit = builder.applicationTaskLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
    this.organizationId = builder.organizationId;
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceKeys = builder.totalServiceKeys;
    this.totalServices = builder.totalServices;
  }

  /**
   * How many app instances a space can create. (-1 represents an unlimited amount)
   */
  @JsonProperty("app_instance_limit")
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The number of tasks that can be run per app. (-1 represents an unlimited amount)
   */
  @JsonProperty("app_task_limit")
  @Override
  public @Nullable Integer getApplicationTaskLimit() {
    return applicationTaskLimit;
  }

  /**
   * The maximum amount of memory in megabytes an application instance can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("instance_memory_limit")
  @Override
  public @Nullable Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * How much memory in megabytes a space can have
   */
  @JsonProperty("memory_limit")
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * If a space can have non basic services
   */
  @JsonProperty("non_basic_services_allowed")
  @Override
  public @Nullable Boolean getNonBasicServicesAllowed() {
    return nonBasicServicesAllowed;
  }

  /**
   * The owning organization of the space quota
   */
  @JsonProperty("organization_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The space quota definition id
   */
  @JsonProperty("spaceQuotaDefinitionId")
  @JsonIgnore
  @Override
  public String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * How many routes a space can have that use a reserved port. These routes count toward total_routes. (-1 represents an unlimited amount; subject to org quota)
   */
  @JsonProperty("total_reserved_route_ports")
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * How many routes a space can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("total_routes")
  @Override
  public @Nullable Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * How many service keys an organization can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("total_service_keys")
  @Override
  public @Nullable Integer getTotalServiceKeys() {
    return totalServiceKeys;
  }

  /**
   * How many services a space can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("total_services")
  @Override
  public @Nullable Integer getTotalServices() {
    return totalServices;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSpaceQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSpaceQuotaDefinitionRequest
        && equalTo((UpdateSpaceQuotaDefinitionRequest) another);
  }

  private boolean equalTo(UpdateSpaceQuotaDefinitionRequest another) {
    return Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(applicationTaskLimit, another.applicationTaskLimit)
        && Objects.equals(instanceMemoryLimit, another.instanceMemoryLimit)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && Objects.equals(name, another.name)
        && Objects.equals(nonBasicServicesAllowed, another.nonBasicServicesAllowed)
        && Objects.equals(organizationId, another.organizationId)
        && spaceQuotaDefinitionId.equals(another.spaceQuotaDefinitionId)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && Objects.equals(totalRoutes, another.totalRoutes)
        && Objects.equals(totalServiceKeys, another.totalServiceKeys)
        && Objects.equals(totalServices, another.totalServices);
  }

  /**
   * Computes a hash code from attributes: {@code applicationInstanceLimit}, {@code applicationTaskLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code nonBasicServicesAllowed}, {@code organizationId}, {@code spaceQuotaDefinitionId}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServiceKeys}, {@code totalServices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationInstanceLimit);
    h += (h << 5) + Objects.hashCode(applicationTaskLimit);
    h += (h << 5) + Objects.hashCode(instanceMemoryLimit);
    h += (h << 5) + Objects.hashCode(memoryLimit);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(nonBasicServicesAllowed);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + spaceQuotaDefinitionId.hashCode();
    h += (h << 5) + Objects.hashCode(totalReservedRoutePorts);
    h += (h << 5) + Objects.hashCode(totalRoutes);
    h += (h << 5) + Objects.hashCode(totalServiceKeys);
    h += (h << 5) + Objects.hashCode(totalServices);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSpaceQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSpaceQuotaDefinitionRequest{"
        + "applicationInstanceLimit=" + applicationInstanceLimit
        + ", applicationTaskLimit=" + applicationTaskLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", nonBasicServicesAllowed=" + nonBasicServicesAllowed
        + ", organizationId=" + organizationId
        + ", spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceKeys=" + totalServiceKeys
        + ", totalServices=" + totalServices
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.spacequotadefinitions._UpdateSpaceQuotaDefinitionRequest {
    Integer applicationInstanceLimit;
    Integer applicationTaskLimit;
    Integer instanceMemoryLimit;
    Integer memoryLimit;
    String name;
    Boolean nonBasicServicesAllowed;
    String organizationId;
    String spaceQuotaDefinitionId;
    Integer totalReservedRoutePorts;
    Integer totalRoutes;
    Integer totalServiceKeys;
    Integer totalServices;
    @JsonProperty("app_instance_limit")
    public void setApplicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
    }
    @JsonProperty("app_task_limit")
    public void setApplicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
    }
    @JsonProperty("instance_memory_limit")
    public void setInstanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
    }
    @JsonProperty("memory_limit")
    public void setMemoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("non_basic_services_allowed")
    public void setNonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("spaceQuotaDefinitionId")
    @JsonIgnore
    public void setSpaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }
    @JsonProperty("total_reserved_route_ports")
    public void setTotalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
    }
    @JsonProperty("total_routes")
    public void setTotalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
    }
    @JsonProperty("total_service_keys")
    public void setTotalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
    }
    @JsonProperty("total_services")
    public void setTotalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
    }
    @Override
    public Integer getApplicationInstanceLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getApplicationTaskLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstanceMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNonBasicServicesAllowed() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceQuotaDefinitionId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalReservedRoutePorts() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalRoutes() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServiceKeys() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServices() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateSpaceQuotaDefinitionRequest fromJson(Json json) {
    UpdateSpaceQuotaDefinitionRequest.Builder builder = UpdateSpaceQuotaDefinitionRequest.builder();
    if (json.applicationInstanceLimit != null) {
      builder.applicationInstanceLimit(json.applicationInstanceLimit);
    }
    if (json.applicationTaskLimit != null) {
      builder.applicationTaskLimit(json.applicationTaskLimit);
    }
    if (json.instanceMemoryLimit != null) {
      builder.instanceMemoryLimit(json.instanceMemoryLimit);
    }
    if (json.memoryLimit != null) {
      builder.memoryLimit(json.memoryLimit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nonBasicServicesAllowed != null) {
      builder.nonBasicServicesAllowed(json.nonBasicServicesAllowed);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.spaceQuotaDefinitionId != null) {
      builder.spaceQuotaDefinitionId(json.spaceQuotaDefinitionId);
    }
    if (json.totalReservedRoutePorts != null) {
      builder.totalReservedRoutePorts(json.totalReservedRoutePorts);
    }
    if (json.totalRoutes != null) {
      builder.totalRoutes(json.totalRoutes);
    }
    if (json.totalServiceKeys != null) {
      builder.totalServiceKeys(json.totalServiceKeys);
    }
    if (json.totalServices != null) {
      builder.totalServices(json.totalServices);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateSpaceQuotaDefinitionRequest UpdateSpaceQuotaDefinitionRequest}.
   * @return A new UpdateSpaceQuotaDefinitionRequest builder
   */
  public static UpdateSpaceQuotaDefinitionRequest.Builder builder() {
    return new UpdateSpaceQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSpaceQuotaDefinitionRequest UpdateSpaceQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_QUOTA_DEFINITION_ID = 0x1L;
    private long initBits = 0x1L;

    private Integer applicationInstanceLimit;
    private Integer applicationTaskLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Boolean nonBasicServicesAllowed;
    private String organizationId;
    private String spaceQuotaDefinitionId;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServiceKeys;
    private Integer totalServices;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSpaceQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSpaceQuotaDefinitionRequest instance) {
      return from((_UpdateSpaceQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSpaceQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSpaceQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer applicationTaskLimitValue = instance.getApplicationTaskLimit();
      if (applicationTaskLimitValue != null) {
        applicationTaskLimit(applicationTaskLimitValue);
      }
      Integer instanceMemoryLimitValue = instance.getInstanceMemoryLimit();
      if (instanceMemoryLimitValue != null) {
        instanceMemoryLimit(instanceMemoryLimitValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Boolean nonBasicServicesAllowedValue = instance.getNonBasicServicesAllowed();
      if (nonBasicServicesAllowedValue != null) {
        nonBasicServicesAllowed(nonBasicServicesAllowedValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      spaceQuotaDefinitionId(instance.getSpaceQuotaDefinitionId());
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      Integer totalRoutesValue = instance.getTotalRoutes();
      if (totalRoutesValue != null) {
        totalRoutes(totalRoutesValue);
      }
      Integer totalServiceKeysValue = instance.getTotalServiceKeys();
      if (totalServiceKeysValue != null) {
        totalServiceKeys(totalServiceKeysValue);
      }
      Integer totalServicesValue = instance.getTotalServices();
      if (totalServicesValue != null) {
        totalServices(totalServicesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit} attribute.
     * @param applicationTaskLimit The value for applicationTaskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed} attribute.
     * @param nonBasicServicesAllowed The value for nonBasicServicesAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = Objects.requireNonNull(spaceQuotaDefinitionId, "spaceQuotaDefinitionId");
      initBits &= ~INIT_BIT_SPACE_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys} attribute.
     * @param totalServiceKeys The value for totalServiceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionRequest#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
      return this;
    }

    /**
     * Builds a new {@link UpdateSpaceQuotaDefinitionRequest UpdateSpaceQuotaDefinitionRequest}.
     * @return An immutable instance of UpdateSpaceQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSpaceQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSpaceQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_QUOTA_DEFINITION_ID) != 0) attributes.add("spaceQuotaDefinitionId");
      return "Cannot build UpdateSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
