package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Disassociate Auditor with the Space by Username operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveSpaceAuditorByUsernameRequest", generator = "Immutables")
public final class RemoveSpaceAuditorByUsernameRequest
    extends org.cloudfoundry.client.v2.spaces._RemoveSpaceAuditorByUsernameRequest {
  private final @Nullable String origin;
  private final String spaceId;
  private final String username;

  private RemoveSpaceAuditorByUsernameRequest(RemoveSpaceAuditorByUsernameRequest.Builder builder) {
    this.origin = builder.origin;
    this.spaceId = builder.spaceId;
    this.username = builder.username;
  }

  /**
   * The origin
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The space id
   */
  @JsonProperty("spaceId")
  @JsonIgnore
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The username
   */
  @JsonProperty("username")
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSpaceAuditorByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSpaceAuditorByUsernameRequest
        && equalTo((RemoveSpaceAuditorByUsernameRequest) another);
  }

  private boolean equalTo(RemoveSpaceAuditorByUsernameRequest another) {
    return Objects.equals(origin, another.origin)
        && spaceId.equals(another.spaceId)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code origin}, {@code spaceId}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSpaceAuditorByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSpaceAuditorByUsernameRequest{"
        + "origin=" + origin
        + ", spaceId=" + spaceId
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spaces._RemoveSpaceAuditorByUsernameRequest {
    String origin;
    String spaceId;
    String username;
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("spaceId")
    @JsonIgnore
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("username")
    public void setUsername(String username) {
      this.username = username;
    }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RemoveSpaceAuditorByUsernameRequest fromJson(Json json) {
    RemoveSpaceAuditorByUsernameRequest.Builder builder = RemoveSpaceAuditorByUsernameRequest.builder();
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RemoveSpaceAuditorByUsernameRequest RemoveSpaceAuditorByUsernameRequest}.
   * @return A new RemoveSpaceAuditorByUsernameRequest builder
   */
  public static RemoveSpaceAuditorByUsernameRequest.Builder builder() {
    return new RemoveSpaceAuditorByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSpaceAuditorByUsernameRequest RemoveSpaceAuditorByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String origin;
    private String spaceId;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSpaceAuditorByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSpaceAuditorByUsernameRequest instance) {
      return from((_RemoveSpaceAuditorByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSpaceAuditorByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSpaceAuditorByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      spaceId(instance.getSpaceId());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceAuditorByUsernameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceAuditorByUsernameRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceAuditorByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link RemoveSpaceAuditorByUsernameRequest RemoveSpaceAuditorByUsernameRequest}.
     * @return An immutable instance of RemoveSpaceAuditorByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSpaceAuditorByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSpaceAuditorByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build RemoveSpaceAuditorByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
