package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Remove Manager from the Space operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveSpaceManagerRequest", generator = "Immutables")
public final class RemoveSpaceManagerRequest
    extends org.cloudfoundry.client.v2.spaces._RemoveSpaceManagerRequest {
  private final String managerId;
  private final String spaceId;

  private RemoveSpaceManagerRequest(RemoveSpaceManagerRequest.Builder builder) {
    this.managerId = builder.managerId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The manager id
   */
  @Override
  public String getManagerId() {
    return managerId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSpaceManagerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSpaceManagerRequest
        && equalTo((RemoveSpaceManagerRequest) another);
  }

  private boolean equalTo(RemoveSpaceManagerRequest another) {
    return managerId.equals(another.managerId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code managerId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + managerId.hashCode();
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSpaceManagerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSpaceManagerRequest{"
        + "managerId=" + managerId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveSpaceManagerRequest RemoveSpaceManagerRequest}.
   * @return A new RemoveSpaceManagerRequest builder
   */
  public static RemoveSpaceManagerRequest.Builder builder() {
    return new RemoveSpaceManagerRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSpaceManagerRequest RemoveSpaceManagerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MANAGER_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String managerId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSpaceManagerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSpaceManagerRequest instance) {
      return from((_RemoveSpaceManagerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSpaceManagerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSpaceManagerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      managerId(instance.getManagerId());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceManagerRequest#getManagerId() managerId} attribute.
     * @param managerId The value for managerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(String managerId) {
      this.managerId = Objects.requireNonNull(managerId, "managerId");
      initBits &= ~INIT_BIT_MANAGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceManagerRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveSpaceManagerRequest RemoveSpaceManagerRequest}.
     * @return An immutable instance of RemoveSpaceManagerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSpaceManagerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSpaceManagerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANAGER_ID) != 0) attributes.add("managerId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build RemoveSpaceManagerRequest, some of required attributes are not set " + attributes;
    }
  }
}
