package org.cloudfoundry.client.v2.stacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Stack operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetStackRequest", generator = "Immutables")
public final class GetStackRequest extends org.cloudfoundry.client.v2.stacks._GetStackRequest {
  private final String stackId;

  private GetStackRequest(GetStackRequest.Builder builder) {
    this.stackId = builder.stackId;
  }

  /**
   * The stack id
   */
  @Override
  public String getStackId() {
    return stackId;
  }

  /**
   * This instance is equal to all instances of {@code GetStackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetStackRequest
        && equalTo((GetStackRequest) another);
  }

  private boolean equalTo(GetStackRequest another) {
    return stackId.equals(another.stackId);
  }

  /**
   * Computes a hash code from attributes: {@code stackId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + stackId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetStackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetStackRequest{"
        + "stackId=" + stackId
        + "}";
  }

  /**
   * Creates a builder for {@link GetStackRequest GetStackRequest}.
   * @return A new GetStackRequest builder
   */
  public static GetStackRequest.Builder builder() {
    return new GetStackRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetStackRequest GetStackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_STACK_ID = 0x1L;
    private long initBits = 0x1L;

    private String stackId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetStackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetStackRequest instance) {
      return from((_GetStackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetStackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetStackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      stackId(instance.getStackId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetStackRequest#getStackId() stackId} attribute.
     * @param stackId The value for stackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(String stackId) {
      this.stackId = Objects.requireNonNull(stackId, "stackId");
      initBits &= ~INIT_BIT_STACK_ID;
      return this;
    }

    /**
     * Builds a new {@link GetStackRequest GetStackRequest}.
     * @return An immutable instance of GetStackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetStackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetStackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STACK_ID) != 0) attributes.add("stackId");
      return "Cannot build GetStackRequest, some of required attributes are not set " + attributes;
    }
  }
}
