package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Billing Managed Organization with the User operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_AssociateUserBillingManagedOrganizationRequest", generator = "Immutables")
public final class AssociateUserBillingManagedOrganizationRequest
    extends org.cloudfoundry.client.v2.users._AssociateUserBillingManagedOrganizationRequest {
  private final String billingManagedOrganizationId;
  private final String userId;

  private AssociateUserBillingManagedOrganizationRequest(AssociateUserBillingManagedOrganizationRequest.Builder builder) {
    this.billingManagedOrganizationId = builder.billingManagedOrganizationId;
    this.userId = builder.userId;
  }

  /**
   * The id of the billing managed organization
   */
  @Override
  public String getBillingManagedOrganizationId() {
    return billingManagedOrganizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateUserBillingManagedOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateUserBillingManagedOrganizationRequest
        && equalTo((AssociateUserBillingManagedOrganizationRequest) another);
  }

  private boolean equalTo(AssociateUserBillingManagedOrganizationRequest another) {
    return billingManagedOrganizationId.equals(another.billingManagedOrganizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code billingManagedOrganizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + billingManagedOrganizationId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateUserBillingManagedOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateUserBillingManagedOrganizationRequest{"
        + "billingManagedOrganizationId=" + billingManagedOrganizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateUserBillingManagedOrganizationRequest AssociateUserBillingManagedOrganizationRequest}.
   * @return A new AssociateUserBillingManagedOrganizationRequest builder
   */
  public static AssociateUserBillingManagedOrganizationRequest.Builder builder() {
    return new AssociateUserBillingManagedOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateUserBillingManagedOrganizationRequest AssociateUserBillingManagedOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BILLING_MANAGED_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String billingManagedOrganizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateUserBillingManagedOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateUserBillingManagedOrganizationRequest instance) {
      return from((_AssociateUserBillingManagedOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateUserBillingManagedOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateUserBillingManagedOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      billingManagedOrganizationId(instance.getBillingManagedOrganizationId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserBillingManagedOrganizationRequest#getBillingManagedOrganizationId() billingManagedOrganizationId} attribute.
     * @param billingManagedOrganizationId The value for billingManagedOrganizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationId(String billingManagedOrganizationId) {
      this.billingManagedOrganizationId = Objects.requireNonNull(billingManagedOrganizationId, "billingManagedOrganizationId");
      initBits &= ~INIT_BIT_BILLING_MANAGED_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserBillingManagedOrganizationRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateUserBillingManagedOrganizationRequest AssociateUserBillingManagedOrganizationRequest}.
     * @return An immutable instance of AssociateUserBillingManagedOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateUserBillingManagedOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateUserBillingManagedOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BILLING_MANAGED_ORGANIZATION_ID) != 0) attributes.add("billingManagedOrganizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build AssociateUserBillingManagedOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
