package org.cloudfoundry.client.v2.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for the User Space resource
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UserSpaceEntity", generator = "Immutables")
public final class UserSpaceEntity extends org.cloudfoundry.client.v2.users._UserSpaceEntity {
  private final @Nullable String name;

  private UserSpaceEntity(UserSpaceEntity.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code UserSpaceEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserSpaceEntity
        && equalTo((UserSpaceEntity) another);
  }

  private boolean equalTo(UserSpaceEntity another) {
    return Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code UserSpaceEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserSpaceEntity{"
        + "name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.users._UserSpaceEntity {
    String name;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserSpaceEntity fromJson(Json json) {
    UserSpaceEntity.Builder builder = UserSpaceEntity.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserSpaceEntity UserSpaceEntity}.
   * @return A new UserSpaceEntity builder
   */
  public static UserSpaceEntity.Builder builder() {
    return new UserSpaceEntity.Builder();
  }

  /**
   * Builds instances of type {@link UserSpaceEntity UserSpaceEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserSpaceEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserSpaceEntity instance) {
      return from((_UserSpaceEntity) instance);
    }

    /**
     * Copy abstract value type {@code _UserSpaceEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserSpaceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserSpaceEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link UserSpaceEntity UserSpaceEntity}.
     * @return An immutable instance of UserSpaceEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserSpaceEntity build() {
      return new UserSpaceEntity(this);
    }
  }
}
