package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The v3 error payload object
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Errors", generator = "Immutables")
public final class Errors extends org.cloudfoundry.client.v3._Errors {
  private final List<Error> errors;

  private Errors(Errors.Builder builder) {
    this.errors = createUnmodifiableList(true, builder.errors);
  }

  /**
   * The errors
   */
  @JsonProperty("errors")
  @Override
  public List<Error> getErrors() {
    return errors;
  }

  /**
   * This instance is equal to all instances of {@code Errors} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Errors
        && equalTo((Errors) another);
  }

  private boolean equalTo(Errors another) {
    return errors.equals(another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + errors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Errors} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Errors{"
        + "errors=" + errors
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Errors {
    List<Error> errors = Collections.emptyList();
    @JsonProperty("errors")
    public void setErrors(List<Error> errors) {
      this.errors = errors;
    }
    @Override
    public List<Error> getErrors() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Errors fromJson(Json json) {
    Errors.Builder builder = Errors.builder();
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Errors Errors}.
   * @return A new Errors builder
   */
  public static Errors.Builder builder() {
    return new Errors.Builder();
  }

  /**
   * Builds instances of type {@link Errors Errors}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<Error> errors = new ArrayList<Error>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Errors} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Errors instance) {
      return from((_Errors) instance);
    }

    /**
     * Copy abstract value type {@code _Errors} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Errors instance) {
      Objects.requireNonNull(instance, "instance");
      addAllErrors(instance.getErrors());
      return this;
    }

    /**
     * Adds one element to {@link Errors#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(Error element) {
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link Errors#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errors(Error... elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Errors#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final Builder errors(Iterable<? extends Error> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link Errors#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends Error> elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Builds a new {@link Errors Errors}.
     * @return An immutable instance of Errors
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Errors build() {
      return new Errors(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
