package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * A link payload
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Link", generator = "Immutables")
public final class Link extends org.cloudfoundry.client.v3._Link {
  private final String href;
  private final @Nullable String method;

  private Link(Link.Builder builder) {
    this.href = builder.href;
    this.method = builder.method;
  }

  /**
   * The href
   */
  @JsonProperty("href")
  @Override
  public String getHref() {
    return href;
  }

  /**
   * The method
   */
  @JsonProperty("method")
  @Override
  public @Nullable String getMethod() {
    return method;
  }

  /**
   * This instance is equal to all instances of {@code Link} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Link
        && equalTo((Link) another);
  }

  private boolean equalTo(Link another) {
    return href.equals(another.href)
        && Objects.equals(method, another.method);
  }

  /**
   * Computes a hash code from attributes: {@code href}, {@code method}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + href.hashCode();
    h += (h << 5) + Objects.hashCode(method);
    return h;
  }

  /**
   * Prints the immutable value {@code Link} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Link{"
        + "href=" + href
        + ", method=" + method
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Link {
    String href;
    String method;
    @JsonProperty("href")
    public void setHref(String href) {
      this.href = href;
    }
    @JsonProperty("method")
    public void setMethod(@Nullable String method) {
      this.method = method;
    }
    @Override
    public String getHref() { throw new UnsupportedOperationException(); }
    @Override
    public String getMethod() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Link fromJson(Json json) {
    Link.Builder builder = Link.builder();
    if (json.href != null) {
      builder.href(json.href);
    }
    if (json.method != null) {
      builder.method(json.method);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Link Link}.
   * @return A new Link builder
   */
  public static Link.Builder builder() {
    return new Link.Builder();
  }

  /**
   * Builds instances of type {@link Link Link}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_HREF = 0x1L;
    private long initBits = 0x1L;

    private String href;
    private String method;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Link} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Link instance) {
      return from((_Link) instance);
    }

    /**
     * Copy abstract value type {@code _Link} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Link instance) {
      Objects.requireNonNull(instance, "instance");
      href(instance.getHref());
      String methodValue = instance.getMethod();
      if (methodValue != null) {
        method(methodValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Link#getHref() href} attribute.
     * @param href The value for href 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("href")
    public final Builder href(String href) {
      this.href = Objects.requireNonNull(href, "href");
      initBits &= ~INIT_BIT_HREF;
      return this;
    }

    /**
     * Initializes the value for the {@link Link#getMethod() method} attribute.
     * @param method The value for method (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("method")
    public final Builder method(@Nullable String method) {
      this.method = method;
      return this;
    }

    /**
     * Builds a new {@link Link Link}.
     * @return An immutable instance of Link
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Link build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Link(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HREF) != 0) attributes.add("href");
      return "Cannot build Link, some of required attributes are not set " + attributes;
    }
  }
}
